/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.runnable;

import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.backoff.configuration.BackoffConfiguration;
import com.mulesoft.mule.runtime.gw.backoff.session.BackoffBarrier;
import com.mulesoft.mule.runtime.gw.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.exception.IncompatibleApiException;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.exception.UnauthorizedException;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.runnable.GatewayPollerRunnable;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import java.util.Optional;
import org.slf4j.Logger;

public class ApisRunnable
extends GatewayPollerRunnable {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ApisRunnable.class);

    public ApisRunnable(ApiTrackingService apiTrackingService, ApiPlatformSessionFactory platformSessionFactory, BackoffBarrier backoffBarrier, BackoffConfiguration backoffConfiguration) {
        super(apiTrackingService, platformSessionFactory, backoffBarrier, backoffConfiguration);
    }

    protected SessionMetadata execute() {
        return this.profiledExecution(() -> {
            LOGGER.debug("Collecting sources across all applications");
            ApiPlatformSession platform = this.platformSessionFactory.create();
            this.apiTrackingService.getTrackedApis().forEach(api -> {
                LOGGER.debug("Fetching policies for {}", api);
                try {
                    this.getApi((Api)api, platform).ifPresent(apiResponse -> {
                        if (apiResponse.hasUpdates().booleanValue()) {
                            LOGGER.debug("Retrieved {} policies for API {}", (Object)apiResponse.countPolicies(), api);
                            this.apiTrackingService.apiTracked(api.getKey(), apiResponse.getTrackingInfo(), apiResponse.getPolicySet(), apiResponse.getSlas());
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error occurred. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
                }
            });
            return platform.metadata();
        });
    }

    private Optional<ApiResponse> getApi(Api api, ApiPlatformSession platform) {
        try {
            return Optional.ofNullable(platform.getApi(api));
        }
        catch (NotFoundException nfe) {
            this.apiTrackingService.apiUntracked(api.getKey());
        }
        catch (UnauthorizedException e) {
            LOGGER.error("Cannot get authorization to retrieve API information. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
        }
        catch (IncompatibleApiException e) {
            LOGGER.error("There was an error trying to track API. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
        }
        catch (HttpResponseException e) {
            LOGGER.error("There was an error retrieving API {}. {} Server status: {}", new Object[]{api, ExceptionDescriptor.errorMessage((Throwable)e), e.statusCode()});
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error occurred retrieving policies. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
        }
        return Optional.empty();
    }
}

