/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.runnable;

import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.backoff.configuration.BackoffConfiguration;
import com.mulesoft.mule.runtime.gw.backoff.session.BackoffBarrier;
import com.mulesoft.mule.runtime.gw.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.adapter.ClientDtoAdapter;
import com.mulesoft.mule.runtime.gw.client.exception.HttpResponseException;
import com.mulesoft.mule.runtime.gw.client.exception.UnauthorizedException;
import com.mulesoft.mule.runtime.gw.client.session.ApiPlatformSession;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.runnable.GatewayPollerRunnable;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class ClientsRunnable
extends GatewayPollerRunnable {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ClientsRunnable.class);

    public ClientsRunnable(ApiTrackingService apiTrackingService, ApiPlatformSessionFactory platformSessionFactory, BackoffBarrier backoffBarrier, BackoffConfiguration backoffConfiguration) {
        super(apiTrackingService, platformSessionFactory, backoffBarrier, backoffConfiguration);
    }

    protected SessionMetadata execute() {
        return this.profiledExecution(() -> {
            LOGGER.debug("Collecting clients across all APIS");
            ApiPlatformSession platform = this.platformSessionFactory.create();
            this.apiTrackingService.getTrackedApisRequiringContracts().forEach(api -> {
                LOGGER.debug("Fetching clients for {}", api);
                try {
                    List clients = platform.getApiClients(api.getTrackingInfo().getOrganizationId(), api.getTrackingInfo().getEnvironmentId(), api.getKey().id()).stream().map(ClientDtoAdapter::new).filter(this::withNullIdOrSecret).collect(Collectors.toList());
                    LOGGER.debug("Retrieved {} clients for {}", (Object)clients.size(), api);
                    this.apiTrackingService.clientsPolling(api.getKey(), clients);
                }
                catch (UnauthorizedException e) {
                    LOGGER.error("Cannot get authorization to retrieve API information. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
                }
                catch (HttpResponseException e) {
                    LOGGER.error("There was an error retrieving contracts for API {}. {} Server status: {}", new Object[]{api, ExceptionDescriptor.errorMessage((Throwable)e), e.statusCode()});
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error occurred. {}", (Object)ExceptionDescriptor.errorMessage((Throwable)e));
                }
            });
            return platform.metadata();
        });
    }

    private boolean withNullIdOrSecret(ClientDtoAdapter client) {
        if (client.id() == null) {
            LOGGER.trace("Null clientId found for client");
            return false;
        }
        if (client.secret() == null) {
            LOGGER.trace("Null secret found for clientId");
            return false;
        }
        return true;
    }
}

