/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.runnable;

import com.mulesoft.mule.runtime.gw.backoff.configuration.BackoffConfiguration;
import com.mulesoft.mule.runtime.gw.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.mule.runtime.gw.backoff.session.BackoffBarrier;
import com.mulesoft.mule.runtime.gw.backoff.session.SessionMetadata;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GatewayPollerRunnable
extends BackoffRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayPollerRunnable.class);
    protected final ApiTrackingService apiTrackingService;
    protected final ApiPlatformSessionFactory platformSessionFactory;

    public GatewayPollerRunnable(ApiTrackingService apiTrackingService, ApiPlatformSessionFactory platformSessionFactory, BackoffBarrier backoffBarrier, BackoffConfiguration backoffConfiguration) {
        super(backoffConfiguration, backoffBarrier);
        this.platformSessionFactory = platformSessionFactory;
        this.apiTrackingService = apiTrackingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SessionMetadata profiledExecution(Supplier<SessionMetadata> sessionMetadataSupplier) {
        SessionMetadata sessionMetadata;
        int apiCount = 0;
        long startTime = System.currentTimeMillis();
        try {
            SessionMetadata sessionMetadata2 = sessionMetadataSupplier.get();
            apiCount = sessionMetadata2.requests();
            sessionMetadata = sessionMetadata2;
        }
        catch (Throwable throwable) {
            if (LOGGER.isDebugEnabled()) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                LOGGER.debug("-= {} cycle complete ({} apis - took {}ms)", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), apiCount, elapsedTime});
            }
            throw throwable;
        }
        if (LOGGER.isDebugEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            LOGGER.debug("-= {} cycle complete ({} apis - took {}ms)", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), apiCount, elapsedTime});
        }
        return sessionMetadata;
    }
}

