/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.service;

import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.agent.HealthCheck;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.autodiscovery.ApiDiscovery;
import com.mulesoft.mule.runtime.gw.config.HighDensityProxyConfiguration;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.deployment.notification.ApiNotificationManager;
import com.mulesoft.mule.runtime.gw.hdp.ApiRegistryWatcher;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.hdp.ApiRegistry;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.DefaultHealthCheck;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.slf4j.Logger;

public class DefaultApiService
implements ApiService,
DeploymentListener {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ApiService.class);
    private final ApiDiscovery apiDiscovery;
    private final DeploymentService deploymentService;
    private final ApiNotificationManager apiNotificationManager;
    private final Map<ApiKey, Api> apis = Collections.synchronizedMap(new WeakHashMap());
    private final List<ApiRegistryWatcher> apiRegistryWatchers = new ArrayList<ApiRegistryWatcher>();
    private final HealthCheck healthCheck;
    private final HighDensityProxyConfiguration hdpConfiguration = new HighDensityProxyConfiguration();

    public DefaultApiService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
        this.apiDiscovery = new ApiDiscovery();
        this.apiNotificationManager = new ApiNotificationManager();
        this.healthCheck = new DefaultHealthCheck(this);
    }

    public void onArtifactInitialised(String artifactName, Registry registry) {
        Application application = this.deploymentService.findApplication(artifactName);
        this.apiDiscovery.autoDiscoveryMetadatas(registry).forEach(apiMetadata -> {
            ApiKey apiKey = apiMetadata.getApiKey();
            Map<ApiKey, Api> map = this.apis;
            synchronized (map) {
                if (!this.apis.containsKey(apiKey)) {
                    LOGGER.debug("New API deployment {}, on app {}", (Object)apiKey, (Object)artifactName);
                    ApiImplementation implementation = new ApiImplementation(apiKey, application, apiMetadata.getFlow());
                    Api api = new Api(apiKey, implementation);
                    this.apis.put(implementation.getApiKey(), api);
                    this.apiNotificationManager.notifyApiDeploymentStart(api);
                } else {
                    LOGGER.warn("API {} is already deployed on app {}. This API deployment won't be tracked.", apiMetadata, (Object)this.apis.get(apiKey).getImplementation().getArtifactName());
                }
            }
        });
    }

    public void onDeploymentSuccess(String artifactName) {
        this.findApiByArtifactName(artifactName).forEach(arg_0 -> ((ApiNotificationManager)this.apiNotificationManager).notifyApiDeploymentSuccess(arg_0));
        if (this.isHighDensityProxy(this.deploymentService.findApplication(artifactName).getRegistry())) {
            ApiRegistryWatcher apiRegistryWatcher = new ApiRegistryWatcher(this, artifactName);
            this.apiRegistryWatchers.add(apiRegistryWatcher);
            try {
                apiRegistryWatcher.initialise();
                apiRegistryWatcher.start();
            }
            catch (Exception e) {
                LOGGER.error(String.format("Error starting High Density Proxy registry monitor for artifact %s", artifactName), (Throwable)e);
            }
        }
    }

    @Override
    public boolean isHighDensityProxy(Registry registry) {
        Optional configurationProperties;
        if (registry != null && (configurationProperties = registry.lookupByType(ConfigurationProperties.class)) != null && configurationProperties.isPresent()) {
            Optional hdp = ((ConfigurationProperties)configurationProperties.get()).resolveBooleanProperty(this.hdpConfiguration.getHdpApplicationProperty());
            return hdp.orElse(false);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDeploymentFailure(String artifactName, Throwable cause) {
        Map<ApiKey, Api> map = this.apis;
        synchronized (map) {
            this.findApiByArtifactName(artifactName).forEach(api -> this.apis.remove(api.getKey()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUndeploymentStart(String artifactName) {
        Map<ApiKey, Api> map = this.apis;
        synchronized (map) {
            List<Api> undeployedApis = this.findApiByArtifactName(artifactName);
            undeployedApis.forEach(api -> {
                LOGGER.debug("API {} un-deployment started", api);
                this.apiNotificationManager.notifyApiUndeploymentStart(api.getImplementation());
                api.dispose();
                this.apis.remove(api.getKey());
            });
            this.apiRegistryWatchers.stream().filter(arw -> arw.getArtifactName().equals(artifactName)).findFirst().ifPresent(ApiRegistryWatcher::stop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRedeploymentStart(String artifactName) {
        Map<ApiKey, Api> map = this.apis;
        synchronized (map) {
            List<Api> redeployedApis = this.findApiByArtifactName(artifactName);
            redeployedApis.forEach(api -> {
                LOGGER.debug("API {} re-deployment started", api);
                this.apiNotificationManager.notifyApiRedeploymentStart(api.getImplementation());
                this.apis.remove(api.getKey());
            });
        }
    }

    @Override
    public boolean isDeployed(ApiKey apiKey) {
        return this.apis.containsKey(apiKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<ApiImplementation> getImplementation(ApiKey apiKey) {
        Map<ApiKey, Api> map = this.apis;
        synchronized (map) {
            return this.apis.containsKey(apiKey) ? Optional.ofNullable(this.apis.get(apiKey).getImplementation()) : Optional.empty();
        }
    }

    @Override
    public Optional<Api> get(ApiKey apiKey) {
        return Optional.ofNullable(this.apis.get(apiKey));
    }

    @Override
    public Optional<Api> find(Flow flow) {
        return this.apis.values().stream().filter(internalApi -> flow.equals(internalApi.getImplementation().getFlow())).findFirst();
    }

    @Override
    public Optional<Api> findHdpApi(Flow flow, String service) {
        return this.apis.values().stream().filter(api -> flow.equals(api.getImplementation().getFlow()) && service.equals(api.getImplementation().getHdpService().orElse(null))).findFirst();
    }

    @Override
    public List<Api> getApis() {
        return new ArrayList<Api>(this.apis.values());
    }

    @Override
    public void addDeploymentListener(ApiDeploymentListener apiDeploymentListener) {
        this.apiNotificationManager.addApiDeploymentListener(apiDeploymentListener);
    }

    @Override
    public void removeDeploymentListener(ApiDeploymentListener apiDeploymentListener) {
        this.apiNotificationManager.removeApiDeploymentListener(apiDeploymentListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHdpApis(ApiRegistry apiRegistry) {
        String appName = apiRegistry.getApplicationName();
        Application application = this.deploymentService.findApplication(appName);
        Map<ApiKey, Api> map = this.apis;
        synchronized (map) {
            this.findApiByArtifactName(appName).stream().filter(api -> !apiRegistry.containsApi((Api)api) && !api.isOffline()).forEach(api -> {
                LOGGER.debug("Removing API deployment {}({}), on high density proxy {}", new Object[]{api.getKey().id(), api.getImplementation().getHdpService().orElse("<null>"), appName});
                this.apiNotificationManager.notifyApiUndeploymentStart(api.getImplementation());
                api.dispose();
                this.apis.remove(api.getKey());
            });
            apiRegistry.getApiRecords().forEach(t -> {
                if (!this.apis.containsKey(t.getApiKey())) {
                    LOGGER.debug("New API deployment {}, on high density proxy {}", t, (Object)appName);
                    ApiImplementation implementation = new ApiImplementation(t.getApiKey(), application, this.getHdpFlow(application), t.getServiceName());
                    Api api = new Api(t.getApiKey(), implementation);
                    this.apis.put(implementation.getApiKey(), api);
                    application.getRegistry().lookupByName("hdp-apis-healthcheck").ifPresent(apisHealthCheck -> ((Map)apisHealthCheck).put(String.format("hdp-hc-%s-%s", appName, api.getImplementation().getApiKey().id().toString()), this.healthCheck.getApiValidator(api.getImplementation().getApiKey().id())));
                    this.apiNotificationManager.notifyApiDeploymentSuccess(api);
                } else if (!appName.equals(this.apis.get(t.getApiKey()).getImplementation().getArtifactName())) {
                    LOGGER.error("API {} is already deployed on app {}. This API deployment won't be tracked.", (Object)t.getApiKey(), (Object)this.apis.get(t.getApiKey()).getImplementation().getArtifactName());
                }
            });
        }
    }

    private Flow getHdpFlow(Application application) {
        Optional hdpFlow = application.getRegistry().lookupByType(Flow.class);
        return (Flow)hdpFlow.orElseThrow(() -> new RuntimeException("HDP application has no flows"));
    }

    public Optional<ApiContracts> getContracts(ApiKey key) {
        return this.get(key).map(Api::getContracts);
    }

    private List<Api> findApiByArtifactName(String artifactName) {
        return this.getApis().stream().filter(api -> artifactName.equals(api.getImplementation().getArtifactName())).collect(Collectors.toList());
    }
}

