/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.tracking;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.logging.ExceptionDescriptor;
import com.mulesoft.mule.runtime.gw.client.exception.IncompatibleApiException;
import com.mulesoft.mule.runtime.gw.client.exception.NotFoundException;
import com.mulesoft.mule.runtime.gw.client.model.ApiResponse;
import com.mulesoft.mule.runtime.gw.client.session.factory.ApiPlatformSessionFactory;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingFailedException;
import com.mulesoft.mule.runtime.gw.deployment.tracking.ApiTrackingService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.retry.RunnableRetrier;
import org.mule.runtime.api.lifecycle.Disposable;
import org.slf4j.Logger;

public class ApiTracker
implements ApiDeploymentListener,
Disposable {
    public static final String RETRY_NAME = "agw-api-tracking-retry";
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ApiTracker.class);
    private final ApiTrackingService apiTrackingService;
    private final ApiPlatformSessionFactory platformSessionFactory;
    private final RunnableRetrier<ApiKey> runnableRetrier;

    public ApiTracker(ApiTrackingService apiTrackingService, ApiPlatformSessionFactory platformSessionFactory, RunnableRetrier<ApiKey> runnableRetrier) {
        this.apiTrackingService = apiTrackingService;
        this.platformSessionFactory = platformSessionFactory;
        this.runnableRetrier = runnableRetrier;
    }

    public void onApiDeploymentSuccess(Api api) {
        try {
            this.trackApi(api);
        }
        catch (ApiTrackingFailedException e) {
            this.scheduleRetry(api);
        }
    }

    public void trackApi(Api api) {
        if (api.isOffline()) {
            LOGGER.debug("Tracking skipped for offline API {}", (Object)api.getKey());
            return;
        }
        ApiImplementation implementation = api.getImplementation();
        try {
            LOGGER.debug("Tracking API {}", (Object)implementation.getApiKey());
            ApiResponse apiResponse = this.platformSessionFactory.create().getApi(implementation.getApiKey());
            this.apiTrackingService.apiTracked(implementation.getApiKey(), apiResponse.getTrackingInfo(), apiResponse.getPolicySet(), apiResponse.getSlas());
            LOGGER.debug("API {} successfully tracked. API name is {} and version is {} ", new Object[]{implementation.getApiKey(), apiResponse.getTrackingInfo().getInstanceName(), apiResponse.getTrackingInfo().getVersion()});
        }
        catch (NotFoundException e) {
            LOGGER.warn("API with ID {} does not exist in API Platform for the current organization.", (Object)implementation.getApiKey().id());
            this.apiTrackingService.apiUntracked(implementation.getApiKey());
        }
        catch (IncompatibleApiException e) {
            LOGGER.error("There was an error trying to track API {}. {}", (Object)implementation.getApiKey().id(), (Object)ExceptionDescriptor.errorMessage((Throwable)e));
        }
        catch (Exception e) {
            LOGGER.error("Unexpected error occurred trying to track API {}. {}", (Object)implementation.getApiKey().id(), (Object)ExceptionDescriptor.errorMessage((Throwable)e));
            this.apiTrackingService.apiTrackingFailed(implementation.getApiKey());
            throw new ApiTrackingFailedException(e);
        }
    }

    private void scheduleRetry(Api api) {
        this.runnableRetrier.scheduleRetry((Object)api.getKey(), () -> this.trackApi(api));
    }

    public void dispose() {
        this.runnableRetrier.dispose();
    }
}

