/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model;

import com.mulesoft.mule.runtime.gw.api.ApiContracts;
import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.NoTrackingInfo;
import com.mulesoft.mule.runtime.gw.model.TrackingInfo;
import com.mulesoft.mule.runtime.gw.model.contracts.ApiContractsFactory;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.mule.runtime.api.lifecycle.Disposable;

public class Api
implements Disposable {
    private final ApiImplementation implementation;
    private final ApiKey key;
    private final ApiContracts contracts;
    private TrackingInfo trackingInfo;

    public Api(ApiKey key, ApiImplementation implementation) {
        this.key = key;
        this.implementation = implementation;
        this.contracts = ApiContractsFactory.create((ApiKey)key);
        this.trackingInfo = NoTrackingInfo.untracked();
    }

    public ApiKey getKey() {
        return this.key;
    }

    public ApiImplementation getImplementation() {
        return this.implementation;
    }

    public TrackingInfo getTrackingInfo() {
        return this.trackingInfo;
    }

    public ApiContracts getContracts() {
        return this.contracts;
    }

    public void updateTrackingInfo(@Nonnull TrackingInfo trackingInfo) {
        Objects.requireNonNull(trackingInfo, "Tracking information can not be null");
        this.trackingInfo = trackingInfo;
    }

    public void dispose() {
        this.contracts.dispose();
    }

    public boolean isOffline() {
        return this.key.id() < 0L;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Api that = (Api)o;
        if (!this.key.equals((Object)that.key)) {
            return false;
        }
        if (this.implementation != null ? !this.implementation.equals(that.implementation) : that.implementation != null) {
            return false;
        }
        if (!this.trackingInfo.equals(that.trackingInfo)) {
            return false;
        }
        return super.equals(that);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        if (this.implementation != null) {
            result = 31 * result + this.implementation.hashCode();
        }
        result = 31 * result + this.trackingInfo.hashCode();
        result = 31 * result + this.contracts.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("API ");
        if (this.trackingInfo.isTracked()) {
            builder.append(this.trackingInfo.getExchangeAssetName()).append("-").append(this.trackingInfo.getProductVersion()).append("-").append(this.trackingInfo.getInstanceName()).append(" (").append(this.key.id()).append(")");
        } else {
            builder.append(this.key.id());
        }
        return builder.toString();
    }
}

