/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import java.util.Optional;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.policy.PolicyRegistrationException;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;

public class ApiImplementation {
    private ApiKey apiKey;
    private Application application;
    private Flow flow;
    private Status status;
    private final String hdpService;

    public ApiImplementation(ApiKey apiKey, Application application, Flow flow) {
        this(apiKey, application, flow, null);
    }

    public ApiImplementation(ApiKey apiKey, Application application, Flow flow, String hdpService) {
        this.apiKey = apiKey;
        this.application = application;
        this.flow = flow;
        this.status = Status.UNBLOCKED;
        this.hdpService = hdpService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPolicy(PolicyTemplateDescriptor templateDescriptor, PolicyParametrization policyParametrization) throws PolicyRegistrationException {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getArtifactClassloader());
        try {
            this.application.getPolicyManager().addPolicy(templateDescriptor, policyParametrization);
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    public boolean removePolicy(String policyName) {
        return (Boolean)ClassUtils.withContextClassLoader((ClassLoader)this.getArtifactClassloader(), () -> this.application.getPolicyManager().removePolicy(policyName));
    }

    public Flow getFlow() {
        return this.flow;
    }

    public String getArtifactName() {
        return this.application.getArtifactName();
    }

    public ApiKey getApiKey() {
        return this.apiKey;
    }

    public ClassLoader getArtifactClassloader() {
        return this.application.getArtifactClassLoader().getClassLoader();
    }

    public boolean isBlocked() {
        return Status.BLOCKED.equals((Object)this.status);
    }

    public void blocked() {
        this.status = Status.BLOCKED;
    }

    public void unblocked() {
        this.status = Status.UNBLOCKED;
    }

    public Optional<String> getHdpService() {
        return Optional.ofNullable(this.hdpService);
    }

    public boolean isHdp() {
        return this.hdpService != null;
    }

    public static enum Status {
        BLOCKED,
        UNBLOCKED;

    }
}

