/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.model.hdp;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.hdp.ApiRecordDto;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiRegistry {
    private String appName;
    private List<ApiRecordDto> apiRecords;
    private static final ObjectMapper objectMapper;
    private static final Logger LOGGER;

    public ApiRegistry(@JsonProperty(value="apis") List<ApiRecordDto> apiRecords) {
        this(null, apiRecords);
    }

    public ApiRegistry(String appName, List<ApiRecordDto> apiRecords) {
        this.appName = appName;
        this.apiRecords = apiRecords;
    }

    public static ApiRegistry fromFile(String appName, File apiRegistry) {
        ApiRegistry registry = null;
        try {
            LOGGER.debug("about to parse api registry file " + apiRegistry);
            registry = (ApiRegistry)objectMapper.readValue(apiRegistry, (TypeReference)new TypeReference<ApiRegistry>(){});
            registry.appName = appName;
            LOGGER.debug("file parsed: " + registry);
        }
        catch (IOException e) {
            LOGGER.error("Error parsing API registry file " + apiRegistry, (Throwable)e);
            throw new ApiRegistryException(e);
        }
        return registry;
    }

    public String getApplicationName() {
        return this.appName;
    }

    public List<ApiRecordDto> getApiRecords() {
        return this.apiRecords;
    }

    public boolean containsApi(Api api) {
        String service = api.getImplementation().getHdpService().orElse(null);
        return this.apiRecords.stream().anyMatch(r -> r.getApiKey().equals((Object)api.getKey()) && r.getServiceName().equals(service));
    }

    public String toString() {
        return "ApiRegistry{appName='" + this.appName + '\'' + ", apiRecords=" + this.apiRecords + '}';
    }

    static {
        LOGGER = LoggerFactory.getLogger(ApiRegistry.class);
        objectMapper = new ObjectMapper();
    }

    static class ApiRegistryException
    extends RuntimeException {
        public ApiRegistryException(Throwable cause) {
            super(cause);
        }
    }
}

