/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.factory;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mulesoft.mule.runtime.gw.api.policy.HttpHeaderPointcut;
import com.mulesoft.mule.runtime.gw.config.HighDensityProxyConfiguration;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.pointcut.ApiPointcutAdapter;
import com.mulesoft.mule.runtime.gw.policies.pointcut.CompositePointcut;
import com.mulesoft.mule.runtime.gw.policies.pointcut.IsHttpComponentPointcut;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.core.api.policy.PolicyParametrization;
import org.mule.runtime.core.api.policy.PolicyPointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyParametrizationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyParametrizationFactory.class);
    private static final String PARAMETER_ENCRYPTED_PROPERTIES_FILE = "encryptedPropertiesFile";
    private static final String API_ID = "apiId";
    private static final String IS_WSDL_ENDPOINT = "isWsdlEndpoint";
    private static final String IS_WSDL_ENDPOINT_DEFAULT = "false";
    private final HighDensityProxyConfiguration hdpConfiguration = new HighDensityProxyConfiguration();

    public PolicyParametrization create(PolicyDefinition policyDefinition, ApiImplementation implementation, File policyConfigFile, File encryptedPropertiesFile, List<NotificationListener> notificationListeners) {
        Map<String, String> defaultParameters = this.createDefaultParameters(implementation, policyDefinition, encryptedPropertiesFile);
        PolicyPointcut effectivePointcut = this.createEffectivePointcut(policyDefinition, implementation);
        String name = this.buildParametrizationId(policyDefinition.getName(), implementation);
        return new PolicyParametrization(name, effectivePointcut, policyDefinition.getOrder().intValue(), defaultParameters, policyConfigFile, notificationListeners);
    }

    public String buildParametrizationId(String policyName, ApiImplementation implementation) {
        return policyName + "-" + implementation.getFlow().getName();
    }

    private Map<String, String> createDefaultParameters(ApiImplementation implementation, PolicyDefinition policyDefinition, File encryptedPropertiesFile) {
        policyDefinition.getConfigurationData().getConfiguration().getOrDefault(IS_WSDL_ENDPOINT, IS_WSDL_ENDPOINT_DEFAULT);
        String wsdlConfiguration = policyDefinition.getConfigurationData().getConfiguration().getOrDefault(IS_WSDL_ENDPOINT, IS_WSDL_ENDPOINT_DEFAULT).toString();
        return new ImmutableMap.Builder().putAll(this.getEncryptedProperties(encryptedPropertiesFile)).put((Object)API_ID, (Object)implementation.getApiKey().id().toString()).put((Object)IS_WSDL_ENDPOINT, (Object)wsdlConfiguration).build();
    }

    private PolicyPointcut createEffectivePointcut(PolicyDefinition policyDefinition, ApiImplementation implementation) {
        String flowName = implementation.getFlow().getName();
        ApiPointcutAdapter apiPointcutAdapter = new ApiPointcutAdapter(flowName);
        List resourcePointcuts = policyDefinition.getHttpResourcePointcuts();
        CompositePointcut pointcut = CompositePointcut.and((PolicyPointcut)apiPointcutAdapter, (PolicyPointcut)new IsHttpComponentPointcut());
        if (implementation.isHdp()) {
            pointcut = this.applyHdpPointcut(pointcut, implementation);
        }
        if (resourcePointcuts.isEmpty()) {
            LOGGER.debug("There were no resource pointcuts defined for policy {}. It will be applied to {}", (Object)policyDefinition.getName(), (Object)flowName);
            return pointcut;
        }
        return CompositePointcut.and((PolicyPointcut)pointcut, (PolicyPointcut)CompositePointcut.or((List)Lists.newArrayList((Iterable)resourcePointcuts)));
    }

    private CompositePointcut applyHdpPointcut(CompositePointcut pointcut, ApiImplementation implementation) {
        return implementation.getHdpService().map(service -> {
            HttpHeaderPointcut headerPointcut = new HttpHeaderPointcut(this.hdpConfiguration.getHdpServiceHeader(), service);
            LOGGER.debug("Injecting header pointcut {} for service {}", (Object)headerPointcut.toString(), service);
            return CompositePointcut.and((PolicyPointcut)pointcut, (PolicyPointcut)headerPointcut);
        }).orElse(pointcut);
    }

    private Map<String, String> getEncryptedProperties(File encryptedProperties) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Optional.ofNullable(encryptedProperties).map(File::getAbsolutePath).ifPresent(absolutePath -> parameters.put(PARAMETER_ENCRYPTED_PROPERTIES_FILE, (String)absolutePath));
        return parameters;
    }
}

