/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import com.mulesoft.mule.runtime.gw.api.agent.HealthCheck;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import java.util.Optional;
import org.mule.runtime.api.healthcheck.HealthCheckValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHealthCheck
implements HealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHealthCheck.class);
    private ApiService apiService;

    public DefaultHealthCheck(ApiService apiService) {
        this.apiService = apiService;
    }

    public boolean isInstanceTrafficAllowed() {
        boolean trafficAllowed = this.apiService.getApis().stream().noneMatch(api -> api.getImplementation().isBlocked());
        if (LOGGER.isDebugEnabled()) {
            this.logInstanceApiStatus("Checking traffic allowed for the instance", trafficAllowed);
        }
        return trafficAllowed;
    }

    public boolean isApiTrafficAllowed(Long apiId) {
        Optional<Api> trackedApi = this.apiService.getApis().stream().filter(api -> api.getKey().id() == apiId).findFirst();
        if (trackedApi.isPresent()) {
            return !trackedApi.get().getImplementation().isBlocked();
        }
        return false;
    }

    public boolean isApplicationTrafficAllowed(String applicationName) {
        boolean trafficAllowed = this.apiService.getApis().stream().filter(api -> api.getImplementation().getArtifactName().equals(applicationName)).noneMatch(api -> api.getImplementation().isBlocked());
        if (LOGGER.isDebugEnabled()) {
            this.logInstanceApiStatus("Checking traffic allowed for application: " + applicationName, trafficAllowed);
        }
        return trafficAllowed;
    }

    private void logInstanceApiStatus(String title, boolean trafficAllowed) {
        StringBuilder builder = new StringBuilder(title);
        this.apiService.getApis().stream().forEach(api -> {
            builder.append("\n\t\tapplication: ").append(api.getImplementation().getArtifactName());
            builder.append("; api: ").append(api).append("; blocked: ").append(api.getImplementation().isBlocked());
        });
        builder.append("\n\tTRAFFIC ALLOWED: ").append(trafficAllowed).append("\n");
        LOGGER.debug(builder.toString());
    }

    public HealthCheckValidator getValidator(String applicationName) {
        return () -> () -> this.isApplicationTrafficAllowed(applicationName);
    }

    public HealthCheckValidator getApiValidator(Long apiId) {
        return () -> () -> this.isApiTrafficAllowed(apiId);
    }
}

