/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.api.policy.PolicyTemplateKey;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.ApiImplementation;
import com.mulesoft.mule.runtime.gw.model.PolicyConfiguration;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.OfflinePolicyDefinition;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.deployment.InternalPolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.deployment.PolicyDeployer;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.GateKeeper;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.PolicyDeploymentListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleManifest;
import org.slf4j.Logger;

public abstract class GateKeeper
implements PolicyDeploymentListener,
ApiDeploymentListener {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(GateKeeper.class);
    private static final PolicyTemplateKey GATEKEEPER_POLICY_TEMPLATE_KEY = new PolicyTemplateKey("com.mulesoft.anypoint", "mule-gatekeeper-policy-template", MuleManifest.getProductVersion());
    private static final String GATEKEEPER_POLICY_ID = "gatekeeper";
    protected final ApiService apiService;
    private final PolicyDeployer policyDeployer;

    public GateKeeper(ApiService apiService) {
        this.apiService = apiService;
        this.policyDeployer = new InternalPolicyDeployer();
    }

    public void onPolicySetDeploymentCompleted(ApiKey apiKey, PolicySet policySet, List<PolicyDeploymentStatus> deploymentStatuses) {
        this.apiService.get(apiKey).ifPresent(api -> {
            if (this.shouldUnblock((Api)api, policySet, deploymentStatuses)) {
                this.unblockApi((Api)api);
            }
        });
    }

    public void onPoliciesRemoved(ApiKey apiKey) {
        this.apiService.get(apiKey).ifPresent(this::blockApi);
    }

    public void onApiDeploymentStart(Api api) {
        if (!api.getImplementation().isHdp()) {
            MuleContext context = api.getImplementation().getFlow().getMuleContext();
            context.getNotificationManager().addListener((NotificationListener)new GateKeeperMuleContextListener(api, this));
        }
    }

    protected abstract boolean shouldUnblock(Api var1, PolicySet var2, List<PolicyDeploymentStatus> var3);

    protected boolean everyPolicySuccessfullyApplied(List<PolicyDefinition> policyDefinitions, List<PolicyDeploymentStatus> deploymentStatuses) {
        return policyDefinitions.stream().allMatch(policyDefinition -> deploymentStatuses.stream().anyMatch(policyStatus -> policyDefinition.equals((Object)policyStatus.getPolicyDefinition()) && policyStatus.isDeploymentSuccess()));
    }

    protected void blockApi(Api api) {
        ApiImplementation implementation = api.getImplementation();
        if (!implementation.isBlocked()) {
            OfflinePolicyDefinition policyDefinition = new OfflinePolicyDefinition(this.getPolicyId(api), GATEKEEPER_POLICY_TEMPLATE_KEY, implementation.getApiKey(), new ArrayList(), 1, new PolicyConfiguration(Collections.emptyMap()));
            this.policyDeployer.deploy((PolicyDefinition)policyDefinition, api);
            implementation.blocked();
            LOGGER.info("API {} is blocked (unavailable).", (Object)implementation.getApiKey());
        }
    }

    private String getPolicyId(Api api) {
        return "gatekeeper-" + api.getKey().id();
    }

    private void unblockApi(Api api) {
        ApiImplementation implementation = api.getImplementation();
        this.policyDeployer.undeploy(this.getPolicyId(api), api);
        implementation.unblocked();
        LOGGER.info("API {} is now unblocked (available).", (Object)implementation.getApiKey());
    }
}

