/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.policies.lifecyle;

import com.mulesoft.mule.runtime.gw.api.key.ApiKey;
import com.mulesoft.mule.runtime.gw.deployment.ApiService;
import com.mulesoft.mule.runtime.gw.model.Api;
import com.mulesoft.mule.runtime.gw.model.PolicyDefinition;
import com.mulesoft.mule.runtime.gw.model.PolicySet;
import com.mulesoft.mule.runtime.gw.notification.ApiDeploymentListener;
import com.mulesoft.mule.runtime.gw.policies.PolicyDeploymentStatus;
import com.mulesoft.mule.runtime.gw.policies.lifecyle.PolicyDeploymentListener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdpApisHealthCheckListener
implements PolicyDeploymentListener,
ApiDeploymentListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(HdpApisHealthCheckListener.class);
    protected final ApiService apiService;

    public HdpApisHealthCheckListener(ApiService apiService) {
        this.apiService = apiService;
    }

    public void onPolicySetDeploymentCompleted(ApiKey apiKey, PolicySet policySet, List<PolicyDeploymentStatus> deploymentStatuses) {
        this.apiService.get(apiKey).ifPresent(api -> {
            if (api.getImplementation().isHdp() && api.getImplementation().isBlocked() && this.everyPolicySuccessfullyApplied(policySet.getPolicyDefinitions(), deploymentStatuses)) {
                LOGGER.info("Api policy set deployment on hdp complete, unblocking api: {}", (Object)apiKey.toString());
                api.getImplementation().unblocked();
            }
        });
    }

    private boolean everyPolicySuccessfullyApplied(List<PolicyDefinition> policyDefinitions, List<PolicyDeploymentStatus> deploymentStatuses) {
        return policyDefinitions.stream().allMatch(policyDefinition -> deploymentStatuses.stream().anyMatch(policyStatus -> policyDefinition.equals((Object)policyStatus.getPolicyDefinition()) && policyStatus.isDeploymentSuccess()));
    }

    public void onApiDeploymentSuccess(Api api) {
        if (api.getImplementation().isHdp()) {
            LOGGER.info("Api deployment on hdp proxy success, blocking api: " + api.getKey().toString());
            api.getImplementation().blocked();
        }
    }
}

