/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.test.util.ws;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
public class TestWebSocketsClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestWebSocketsClient.class);
    private final LinkedBlockingDeque<String> textsQueue = new LinkedBlockingDeque();
    private final LinkedBlockingDeque<byte[]> binariesQueue = new LinkedBlockingDeque();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        LOGGER.info("WebSocket Close: statusCode [{}], reason [{}]", (Object)statusCode, (Object)reason);
        this.closed.set(true);
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        LOGGER.info("WebSocket Open: {}", (Object)session);
        this.closed.set(false);
    }

    @OnWebSocketError
    public void onError(Throwable cause) {
        LOGGER.error("WebSocket Error", cause);
        this.closed.set(true);
    }

    @OnWebSocketMessage
    public void onText(String message) {
        LOGGER.info("Text Message [{}]", (Object)message);
        this.textsQueue.offer(message);
    }

    @OnWebSocketMessage
    public void onBinary(byte[] payload, int offset, int len) {
        LOGGER.info("Binary Message [{}]", (Object)new String(payload, offset, len, StandardCharsets.UTF_8));
        byte[] message = new byte[len];
        System.arraycopy(payload, offset, message, 0, len);
        this.binariesQueue.offer(message);
    }

    public String takeTextMessage() throws InterruptedException {
        do {
            String polled;
            if ((polled = this.textsQueue.poll(500L, TimeUnit.MILLISECONDS)) == null) continue;
            return polled;
        } while (!this.closed.get());
        throw new IllegalStateException("Test websocket client is closed");
    }

    public byte[] takeBinaryMessage() throws InterruptedException {
        do {
            byte[] polled;
            if ((polled = this.binariesQueue.poll(500L, TimeUnit.MILLISECONDS)) == null) continue;
            return polled;
        } while (!this.closed.get());
        throw new IllegalStateException("Test websocket client is closed");
    }
}

