/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client;

import com.mulesoft.service.http.impl.service.HostNameResolver;
import com.mulesoft.service.http.impl.service.client.builder.DirectNameResolvingRequestBuilder;
import com.mulesoft.service.http.impl.service.client.builder.NameResolvingRequestBuilder;
import com.mulesoft.service.http.impl.service.client.builder.NoNameResolvingRequestHandler;
import com.mulesoft.service.http.impl.service.client.builder.ProxyNameResolvingRequestBuilder;
import com.mulesoft.service.http.impl.service.client.ws.OutboundWebSocket;
import com.mulesoft.service.http.impl.service.client.ws.OutboundWebSocketListener;
import com.mulesoft.service.http.impl.service.client.ws.reconnect.OutboundWebSocketReconnectionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpClientConfigDefaults;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Request;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.providers.grizzly.websocket.GrizzlyWebSocketAdapter;
import com.ning.http.client.ws.BadStatusCodeException;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketListener;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.exception.InvalidStatusCodeException;
import org.mule.runtime.http.api.ws.WebSocketProtocol;
import org.mule.service.http.impl.service.client.GrizzlyHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EEGrizzlyHttpClient
extends GrizzlyHttpClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(EEGrizzlyHttpClient.class);
    private static boolean AHC_PROXY_PROPERTIES = AsyncHttpClientConfigDefaults.defaultUseProxyProperties();
    private final HostNameResolver hostNameResolver;
    private final Map<HttpRequest, NameResolvingRequestBuilder> requestBuilders = new ConcurrentHashMap<HttpRequest, NameResolvingRequestBuilder>();

    public EEGrizzlyHttpClient(HttpClientConfiguration config, SchedulerService schedulerService, SchedulerConfig schedulersConfig, HostNameResolver hostNameResolver) {
        super(config, schedulerService, schedulersConfig);
        this.hostNameResolver = hostNameResolver;
    }

    protected void doConfigureProxy(AsyncHttpClientConfig.Builder builder, ProxyConfig proxyConfig) {
    }

    protected RequestBuilder createRequestBuilder(HttpRequest request, HttpRequestOptions options, GrizzlyHttpClient.RequestConfigurer requestConfigurer) throws IOException {
        if (!this.requestBuilders.containsKey(request)) {
            NameResolvingRequestBuilder requestBuilder = this.doCreateRequestBuilder(request, options);
            requestConfigurer.configure((RequestBuilder)requestBuilder);
            this.requestBuilders.put(request, requestBuilder);
        }
        return this.requestBuilders.get(request);
    }

    protected void onCompleteRedirect(HttpRequest redirectRequest) {
        if (redirectRequest != null) {
            this.requestBuilders.remove(redirectRequest);
        }
    }

    private NameResolvingRequestBuilder doCreateRequestBuilder(HttpRequest request, HttpRequestOptions options) {
        if (this.getProxyConfig() != null) {
            return new ProxyNameResolvingRequestBuilder(request, this.hostNameResolver, options.getProxyConfig().orElse(this.getProxyConfig()));
        }
        if (AHC_PROXY_PROPERTIES) {
            return new NoNameResolvingRequestHandler(request, this.hostNameResolver);
        }
        return new DirectNameResolvingRequestBuilder(request, this.hostNameResolver);
    }

    public HttpResponse send(HttpRequest request, HttpRequestOptions options) throws IOException, TimeoutException {
        try {
            HttpResponse httpResponse = super.send(request, options);
            return httpResponse;
        }
        catch (SocketException e) {
            SocketException lastRetriableException = e;
            while (this.hasMoreAddressesToRetry(request)) {
                try {
                    this.logAddressRetrying(request, e);
                    HttpResponse httpResponse = super.send(request, options);
                    return httpResponse;
                }
                catch (SocketException se) {
                    lastRetriableException = se;
                }
            }
            this.logAddressesDepleted(request);
            throw lastRetriableException;
        }
        finally {
            this.requestBuilders.remove(request);
        }
    }

    public CompletableFuture<HttpResponse> sendAsync(HttpRequest request, HttpRequestOptions options) {
        CompletableFuture<HttpResponse> future = new CompletableFuture<HttpResponse>();
        super.sendAsync(request, options).whenComplete((response, exception) -> {
            if (response != null) {
                this.requestBuilders.remove(request);
                future.complete((HttpResponse)response);
            } else if (exception instanceof SocketException) {
                if (this.hasMoreAddressesToRetry(request)) {
                    this.logAddressRetrying(request, (Throwable)exception);
                    this.sendAsync(request, options).whenComplete((recResponse, recException) -> {
                        if (recResponse != null) {
                            future.complete((HttpResponse)recResponse);
                        } else {
                            future.completeExceptionally((Throwable)recException);
                        }
                    });
                } else {
                    this.logAddressesDepleted(request);
                    this.requestBuilders.remove(request);
                    future.completeExceptionally((Throwable)exception);
                }
            } else {
                this.requestBuilders.remove(request);
                future.completeExceptionally((Throwable)exception);
            }
        });
        return future;
    }

    public CompletableFuture<org.mule.runtime.http.api.ws.WebSocket> openWebSocket(HttpRequest request, HttpRequestOptions requestOptions, String socketId, WebSocketCallback callback) {
        CompletableFuture<org.mule.runtime.http.api.ws.WebSocket> future = new CompletableFuture<org.mule.runtime.http.api.ws.WebSocket>();
        try {
            Request effectiveRequest = this.createGrizzlyRequest(request, requestOptions);
            OutboundWebSocketListener socketListener = new OutboundWebSocketListener(socketId, callback);
            AsyncHttpClient.BoundRequestBuilder reqBuilder = this.asyncHttpClient.prepareRequest(effectiveRequest);
            WebSocketUpgradeHandler upgradeHandler = new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)socketListener).build();
            ListenableFuture listenable = reqBuilder.execute((AsyncHandler)upgradeHandler);
            listenable.addListener(() -> {
                try {
                    WebSocket ws = (WebSocket)listenable.get();
                    OutboundWebSocketReconnectionHandler reconnectionHandler = new OutboundWebSocketReconnectionHandler((HttpClient)this, request, requestOptions, socketId, callback);
                    OutboundWebSocket socket = new OutboundWebSocket(socketId, request.getUri(), WebSocketProtocol.forScheme((String)request.getUri().getScheme()), (GrizzlyWebSocketAdapter)ws, reconnectionHandler);
                    socketListener.setSocket(socket);
                    this.requestBuilders.remove(request);
                    future.complete(socket);
                }
                catch (Throwable t) {
                    if (t.getCause() instanceof ConnectException) {
                        if (this.hasMoreAddressesToRetry(request)) {
                            this.openWebSocket(request, requestOptions, socketId, callback).whenComplete((recResponse, recException) -> {
                                if (recResponse != null) {
                                    future.complete((org.mule.runtime.http.api.ws.WebSocket)recResponse);
                                } else {
                                    future.completeExceptionally((Throwable)recException);
                                }
                            });
                        } else {
                            this.requestBuilders.remove(request);
                            future.completeExceptionally(this.mapException(t));
                        }
                    }
                    this.requestBuilders.remove(request);
                    future.completeExceptionally(this.mapException(t));
                }
            }, Runnable::run);
        }
        catch (Exception e) {
            future.completeExceptionally(this.mapException(e));
        }
        return future;
    }

    private Throwable mapException(Throwable t) {
        if (t instanceof ExecutionException) {
            t = t.getCause();
        }
        if (t instanceof BadStatusCodeException) {
            t = new InvalidStatusCodeException(((BadStatusCodeException)t).getStatus());
        }
        return t;
    }

    protected void logAddressRetrying(HttpRequest request, Throwable e) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Retrying request to '{}' because of {} ({})", new Object[]{request.getUri(), e.getClass().getName(), e.getMessage()});
        }
    }

    protected void logAddressesDepleted(HttpRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Available addresses depleted for request to '{}'. Throwing Exception...", (Object)request.getUri());
        }
    }

    protected boolean hasMoreAddressesToRetry(HttpRequest request) {
        return this.requestBuilders.get(request).hasNextResolvedAddresses();
    }

    public static void refreshSystemProperties() {
        AHC_PROXY_PROPERTIES = AsyncHttpClientConfigDefaults.defaultUseProxyProperties();
    }

    public int getRequestBuildersSize() {
        return this.requestBuilders.size();
    }
}

