/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty;

import com.mulesoft.service.http.impl.netty.NettyOutboundWebSocket;
import com.mulesoft.service.http.impl.netty.NettyOutboundWebSocketReconnectionHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.ssl.SslContext;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.exception.InvalidStatusCodeException;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.service.http.netty.impl.client.WebSocketsProvider;
import org.mule.service.http.netty.impl.util.HttpUtils;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.netty.tcp.SslProvider;

public class NettyOutboundWebSocketsProvider
implements WebSocketsProvider {
    public CompletableFuture<WebSocket> openWebSocket(HttpRequest request, HttpRequestOptions requestOptions, String socketId, WebSocketCallback callback, SslContext sslContext) {
        CompletableFuture<WebSocket> future = new CompletableFuture<WebSocket>();
        String uri = HttpUtils.buildUriString((URI)request.getUri(), (MultiMap)request.getQueryParams());
        HttpClient httpClient = HttpClient.create();
        if (sslContext != null) {
            httpClient = httpClient.secure(SslProvider.builder().sslContext(sslContext).build());
        }
        ((HttpClient.WebsocketSender)httpClient.headers(upgradeRequestHeaders -> {
            for (String headerName : request.getHeaderNames()) {
                upgradeRequestHeaders.add(headerName, (Iterable)request.getHeaderValues(headerName));
            }
        }).websocket().uri(uri)).handle((in, out) -> {
            try {
                NettyOutboundWebSocketReconnectionHandler reconnectionHandler = new NettyOutboundWebSocketReconnectionHandler(this, request, requestOptions, socketId, callback, sslContext);
                NettyOutboundWebSocket webSocket = new NettyOutboundWebSocket((WebsocketInbound)in, (WebsocketOutbound)out, socketId, new URI(uri), callback, reconnectionHandler, sslContext);
                callback.onConnect((WebSocket)webSocket);
                future.complete(webSocket);
                return out.neverComplete();
            }
            catch (Exception e) {
                return Mono.error((Throwable)e);
            }
        }).doOnError(WebSocketClientHandshakeException.class, handshakeException -> {
            HttpResponseStatus status = handshakeException.response().status();
            if (!HttpResponseStatus.SWITCHING_PROTOCOLS.equals((Object)status)) {
                future.completeExceptionally((Throwable)new InvalidStatusCodeException(status.code()));
            }
        }).doOnError(otherError -> {
            if (!future.isDone()) {
                future.completeExceptionally((Throwable)otherError);
            }
        }).onErrorComplete().subscribe();
        return future;
    }
}

