/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty;

import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;

public final class NettyWebSocketFrameToTypedValue {
    private NettyWebSocketFrameToTypedValue() {
    }

    public static TypedValue<InputStream> toTypedValue(WebSocketFrame webSocketFrame, WebSocketRequest originalRequest) {
        if (webSocketFrame == null) {
            throw new IllegalArgumentException("Web socket frame can't be null");
        }
        if (webSocketFrame instanceof TextWebSocketFrame) {
            return NettyWebSocketFrameToTypedValue.textTypedValue((TextWebSocketFrame)webSocketFrame, originalRequest);
        }
        if (webSocketFrame instanceof BinaryWebSocketFrame) {
            return NettyWebSocketFrameToTypedValue.binaryTypedValue((BinaryWebSocketFrame)webSocketFrame, originalRequest);
        }
        throw new IllegalArgumentException("Unknown frame type: " + webSocketFrame.getClass());
    }

    private static TypedValue<InputStream> binaryTypedValue(BinaryWebSocketFrame webSocketFrame, WebSocketRequest originalRequest) {
        ByteBufInputStream stream = new ByteBufInputStream(webSocketFrame.content().retain());
        return new TypedValue((Object)stream, DataType.builder().type(InputStream.class).mediaType(NettyWebSocketFrameToTypedValue.resolveMediaType(originalRequest, MediaType.BINARY)).build());
    }

    private static TypedValue<InputStream> textTypedValue(TextWebSocketFrame webSocketFrame, WebSocketRequest originalRequest) {
        ByteArrayInputStream stream = new ByteArrayInputStream(webSocketFrame.text().getBytes());
        return new TypedValue((Object)stream, DataType.builder().type(InputStream.class).mediaType(NettyWebSocketFrameToTypedValue.resolveMediaType(originalRequest, MediaType.TEXT)).build());
    }

    private static MediaType resolveMediaType(WebSocketRequest request, MediaType defaultMediaType) {
        if (request == null) {
            return defaultMediaType;
        }
        MediaType resolved = request.getContentType();
        if (resolved == MediaType.ANY) {
            resolved = defaultMediaType;
        }
        return resolved;
    }
}

