/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.functional.ws;

import com.mulesoft.service.http.impl.functional.ws.AbstractWebSocketTestCase;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketHandlerManager;
import org.mule.tck.size.SmallTest;

@SmallTest
public class WebSocketServerTestCase
extends AbstractWebSocketTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private List<WebSocketHandlerManager> handlers = new ArrayList<WebSocketHandlerManager>();

    @Test
    public void addRepeatedHandlers() {
        String path = "/repeated";
        server.addWebSocketHandler(this.createMockHandler("/repeated"));
        this.expectedException.expect(MuleRuntimeException.class);
        this.expectedException.expectMessage(Matchers.containsString((String)"Already exists a listener matching that path and methods"));
        this.handlers.add(server.addWebSocketHandler(this.createMockHandler("/repeated")));
    }

    @Test
    public void catchAllDoesntClashWithSpecific() {
        this.handlers.add(server.addWebSocketHandler(this.createMockHandler("/ws/*")));
        this.handlers.add(server.addWebSocketHandler(this.createMockHandler("/ws/specific")));
    }

    private WebSocketHandler createMockHandler(String path) {
        WebSocketHandler handler = (WebSocketHandler)Mockito.mock(WebSocketHandler.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)handler.getPath()).thenReturn((Object)path);
        return handler;
    }

    @Override
    @After
    public void after() {
        this.handlers.forEach(h -> {
            h.stop();
            h.dispose();
        });
        super.after();
    }
}

