/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.functional.ws.netty;

import com.mulesoft.service.http.impl.netty.NettyOutboundWebSocket;
import com.mulesoft.service.http.impl.netty.NettyOutboundWebSocketReconnectionHandler;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.ssl.SslContext;
import io.qameta.allure.Issue;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.tck.junit4.AbstractMuleTestCase;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

@Issue(value="W-16264904")
public class NettyOutboundSocketReconnectionTestCase
extends AbstractMuleTestCase {
    @Rule
    public MockitoRule mockitoRule = MockitoJUnit.rule();
    @Mock
    private WebsocketInbound inbound;
    @Mock
    private WebsocketOutbound outbound;
    @Mock
    private WebSocketCallback callback;
    @Mock
    private NettyOutboundWebSocketReconnectionHandler reconnectionHandler;
    @Mock
    private org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate retryPolicyTemplate;
    @Mock
    private Scheduler scheduler;
    @Mock
    private SslContext sslContext;
    private CompletableFuture<WebSocket> reconnectionFuture = new CompletableFuture();
    private NettyOutboundWebSocket webSocket;

    @Before
    public void before() {
        Flux framesFlux = Flux.empty();
        Mockito.when((Object)this.inbound.receiveFrames()).thenReturn((Object)framesFlux);
        Mono closeStatusMono = Mono.just((Object)WebSocketCloseStatus.NORMAL_CLOSURE);
        Mockito.when((Object)this.inbound.receiveCloseStatus()).thenReturn((Object)closeStatusMono);
        this.webSocket = new NettyOutboundWebSocket(this.inbound, this.outbound, "id", URI.create("ws://mulesoft.com"), this.callback, this.reconnectionHandler, this.sslContext);
        Mockito.when((Object)this.reconnectionHandler.reconnect(this.webSocket, (RetryPolicyTemplate)this.retryPolicyTemplate, this.scheduler)).thenReturn(this.reconnectionFuture);
    }

    @Test
    public void reconnectsTwiceSerially() throws Exception {
        CompletableFuture firstFuture = this.webSocket.reconnect(this.retryPolicyTemplate, this.scheduler);
        ((NettyOutboundWebSocketReconnectionHandler)Mockito.verify((Object)this.reconnectionHandler)).reconnect(this.webSocket, (RetryPolicyTemplate)this.retryPolicyTemplate, this.scheduler);
        WebSocket newSocket = (WebSocket)Mockito.mock(WebSocket.class);
        this.reconnectionFuture.complete(newSocket);
        MatcherAssert.assertThat(firstFuture.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)newSocket)));
        Mockito.reset((Object[])new NettyOutboundWebSocketReconnectionHandler[]{this.reconnectionHandler});
        this.reconnectionFuture = new CompletableFuture();
        Mockito.when((Object)this.reconnectionHandler.reconnect(this.webSocket, (RetryPolicyTemplate)this.retryPolicyTemplate, this.scheduler)).thenReturn(this.reconnectionFuture);
        CompletableFuture secondFuture = this.webSocket.reconnect(this.retryPolicyTemplate, this.scheduler);
        MatcherAssert.assertThat((Object)secondFuture, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance(this.reconnectionFuture))));
        ((NettyOutboundWebSocketReconnectionHandler)Mockito.verify((Object)this.reconnectionHandler)).reconnect(this.webSocket, (RetryPolicyTemplate)this.retryPolicyTemplate, this.scheduler);
    }

    @Test
    public void concurrentReconnectionReturnSameFuture() throws Exception {
        CopyOnWriteArrayList futures = new CopyOnWriteArrayList();
        int top = 5;
        CountDownLatch latch = new CountDownLatch(5);
        for (int i = 0; i < top; i = (int)((short)(i + 1))) {
            new Thread(() -> {
                futures.add(this.webSocket.reconnect(this.retryPolicyTemplate, this.scheduler));
                latch.countDown();
            }).start();
        }
        MatcherAssert.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat(futures, (Matcher)Matchers.hasSize((int)top));
        MatcherAssert.assertThat((Object)futures.stream().allMatch(f -> f == futures.get(0)), (Matcher)CoreMatchers.is((Object)true));
    }
}

