/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.functional.ws.netty;

import com.mulesoft.service.http.impl.functional.ws.netty.AbstractNettyWebSocketTestCase;
import com.mulesoft.service.http.impl.functional.ws.netty.TestWebSocketServer;
import com.mulesoft.service.http.impl.functional.ws.netty.WebSocketCallbackAdapter;
import io.netty.handler.timeout.ReadTimeoutException;
import io.qameta.allure.Issue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.exception.InvalidStatusCodeException;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.probe.PollingProber;

public class NettyWebSocketClientTestCase
extends AbstractNettyWebSocketTestCase {
    @Rule
    public DynamicPort testServerPort = new DynamicPort("testServerPort");

    @Test
    public void echoTextRequestToExternalServer() throws ExecutionException, InterruptedException {
        String testPayload = "Hello echo!";
        HttpRequest request = HttpRequest.builder().uri("ws://localhost:" + this.externalPort.getNumber() + "/wsEcho").build();
        String wsId = "myWebSocketId";
        final StringBuilder receivedData = new StringBuilder();
        WebSocket webSocket = (WebSocket)this.muleHttpClient.openWebSocket(request, wsId, (WebSocketCallback)new WebSocketCallbackAdapter(){

            @Override
            public void onMessage(WebSocket webSocket, TypedValue<InputStream> content) {
                receivedData.append(IOUtils.toString((InputStream)((InputStream)content.getValue())));
            }
        }).get();
        webSocket.send((InputStream)new ByteArrayInputStream(testPayload.getBytes()), MediaType.TEXT);
        PollingProber.probe(() -> testPayload.contentEquals(receivedData));
    }

    @Test
    public void echoBinaryRequestToExternalServer() throws ExecutionException, InterruptedException {
        byte[] testPayload = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
        HttpRequest request = HttpRequest.builder().uri("ws://localhost:" + this.externalPort.getNumber() + "/wsEcho").build();
        String wsId = "myWebSocketId";
        final byte[] receivedData = new byte[testPayload.length];
        final Latch messageReceivedLatch = new Latch();
        WebSocket webSocket = (WebSocket)this.muleHttpClient.openWebSocket(request, wsId, (WebSocketCallback)new WebSocketCallbackAdapter(){

            @Override
            public void onMessage(WebSocket webSocket, TypedValue<InputStream> content) {
                try {
                    ((InputStream)content.getValue()).read(receivedData);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                messageReceivedLatch.release();
            }
        }).get();
        webSocket.send((InputStream)new ByteArrayInputStream(testPayload), MediaType.BINARY);
        messageReceivedLatch.await();
        MatcherAssert.assertThat((Object)receivedData, (Matcher)Matchers.is((Object)testPayload));
    }

    @Test
    public void sendRequestToNotWsEndpoint() {
        HttpRequest request = HttpRequest.builder().uri("ws://localhost:" + this.externalPort.getNumber() + "/notFound").build();
        String wsId = "myWebSocketId";
        ExecutionException exception = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> this.muleHttpClient.openWebSocket(request, wsId, (WebSocketCallback)new WebSocketCallbackAdapter()).get());
        MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)Matchers.instanceOf(InvalidStatusCodeException.class));
        MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.is((Object)"Invalid Status Code 503")));
    }

    @Test
    @Issue(value="W-16264925")
    public void closeFromClient() throws ExecutionException, InterruptedException {
        HttpRequest request = HttpRequest.builder().uri("ws://localhost:" + this.externalPort.getNumber() + "/wsEcho").build();
        String wsId = "myWebSocketId";
        final Latch messageReceivedLatch = new Latch();
        final Reference receivedStatusCode = new Reference();
        final Reference receivedReason = new Reference();
        WebSocket webSocket = (WebSocket)this.muleHttpClient.openWebSocket(request, wsId, (WebSocketCallback)new WebSocketCallbackAdapter(){

            @Override
            public void onClose(WebSocket webSocket, WebSocketCloseCode code, String reason) {
                super.onClose(webSocket, code, reason);
                receivedStatusCode.set((Object)code.getProtocolCode());
                receivedReason.set((Object)reason);
                messageReceivedLatch.release();
            }
        }).get();
        webSocket.close(WebSocketCloseCode.NORMAL_CLOSURE, "Test reason").get();
        messageReceivedLatch.await();
        MatcherAssert.assertThat((Object)((Integer)receivedStatusCode.get()), (Matcher)Matchers.is((Object)1000));
        MatcherAssert.assertThat((Object)((String)receivedReason.get()), (Matcher)Matchers.is((Object)"Test reason"));
    }

    @Test
    @Issue(value="W-16264865")
    public void setHeadersInTheUpgradeRequest() throws ExecutionException, InterruptedException {
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri("ws://localhost:" + this.externalPort.getNumber() + "/wsEcho").addHeaders("testHeaderName", Arrays.asList("value1", "value2"))).build();
        String wsId = "myWebSocketId";
        this.muleHttpClient.openWebSocket(request, wsId, (WebSocketCallback)new WebSocketCallbackAdapter()).get();
        HttpServletRequest upgradeRequest = this.externalServer.takeUpgradeRequest();
        MatcherAssert.assertThat(NettyWebSocketClientTestCase.enumerationToList(upgradeRequest.getHeaders("testHeaderName")), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"value1", "value2"}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Issue(value="W-16381685")
    public void testFollowsRedirectOption() throws Exception {
        TestWebSocketServer testServer = new TestWebSocketServer(this.testServerPort.getNumber());
        testServer.start();
        try {
            HttpRequest request = HttpRequest.builder().uri("ws://localhost:" + this.testServerPort.getNumber() + "/redirect").build();
            String wsId = "testWebSocketId";
            HttpRequestOptions requestOptions = HttpRequestOptions.builder().responseTimeout(5000).followsRedirect(false).build();
            CompletableFuture future = this.muleHttpClient.openWebSocket(request, requestOptions, wsId, (WebSocketCallback)new WebSocketCallbackAdapter());
            ExecutionException exception = (ExecutionException)Assert.assertThrows(ExecutionException.class, future::get);
            MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)Matchers.instanceOf(InvalidStatusCodeException.class));
            MatcherAssert.assertThat((Object)exception.getCause(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"302")));
            requestOptions = HttpRequestOptions.builder().responseTimeout(5000).followsRedirect(true).build();
            WebSocket webSocket = (WebSocket)this.muleHttpClient.openWebSocket(request, requestOptions, wsId, (WebSocketCallback)new WebSocketCallbackAdapter()).get();
            Assert.assertNotNull((Object)webSocket);
            Assert.assertTrue((boolean)webSocket.isConnected());
            webSocket.close(WebSocketCloseCode.NORMAL_CLOSURE, "test");
        }
        finally {
            testServer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Issue(value="W-16381685")
    public void testResponseTimeoutOption() throws Exception {
        TestWebSocketServer testServer = new TestWebSocketServer(this.testServerPort.getNumber());
        testServer.setHandshakeDelay(2000L);
        testServer.start();
        try {
            HttpRequest request = HttpRequest.builder().uri("ws://localhost:" + this.testServerPort.getNumber() + "/delayed").build();
            String wsId = "testWebSocketId";
            HttpRequestOptions requestOptions = HttpRequestOptions.builder().responseTimeout(1000).followsRedirect(true).build();
            CompletableFuture future = this.muleHttpClient.openWebSocket(request, requestOptions, wsId, (WebSocketCallback)new WebSocketCallbackAdapter());
            ExecutionException exception = (ExecutionException)Assert.assertThrows(ExecutionException.class, future::get);
            Throwable cause = exception.getCause();
            if (cause instanceof TimeoutException) {
                MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(TimeoutException.class));
            } else if (cause instanceof ReadTimeoutException) {
                MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(ReadTimeoutException.class));
            } else {
                Assert.fail((String)("Expected a TimeoutException, but got: " + cause));
            }
            testServer.setHandshakeDelay(0L);
            future = this.muleHttpClient.openWebSocket(request, requestOptions, wsId, (WebSocketCallback)new WebSocketCallbackAdapter());
            WebSocket webSocket = (WebSocket)future.get();
            Assert.assertNotNull((Object)webSocket);
            Assert.assertTrue((boolean)webSocket.isConnected());
            webSocket.close(WebSocketCloseCode.NORMAL_CLOSURE, "Test reason");
        }
        finally {
            testServer.stop();
        }
    }

    private static <T> List<T> enumerationToList(Enumeration<T> enumeration) {
        ArrayList<T> result = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            result.add(enumeration.nextElement());
        }
        return result;
    }
}

