/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.functional.ws.netty;

import com.mulesoft.service.http.impl.util.TestWebsocketEchoServer;
import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class TestWebSocketServer {
    private final int portNumber;
    private Server jettyServer;
    private long handshakeDelayMillis = 0L;
    private static final String CONTEXT_PATH = "/";
    private static final String REDIRECT_PATH = "/redirect";
    private static final String FINAL_PATH = "/final";
    private static final String DELAYED_PATH = "/delayed";

    public TestWebSocketServer(int portNumber) {
        this.portNumber = portNumber;
    }

    public void setHandshakeDelay(long delayMillis) {
        this.handshakeDelayMillis = delayMillis;
    }

    public void start() throws Exception {
        this.jettyServer = new Server(this.portNumber);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(CONTEXT_PATH);
        context.addServlet(new ServletHolder("redirectServlet", (Servlet)new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
                String path = req.getRequestURI();
                if (TestWebSocketServer.REDIRECT_PATH.equals(path)) {
                    resp.setStatus(302);
                    resp.setHeader("Location", "ws://localhost:" + TestWebSocketServer.this.portNumber + TestWebSocketServer.FINAL_PATH);
                } else {
                    resp.sendError(404);
                }
            }
        }), REDIRECT_PATH);
        ServletHolder wsFinalHolder = new ServletHolder("ws-final", (Servlet)new WebSocketServlet(){

            public void configure(WebSocketServletFactory factory) {
                factory.register(TestWebsocketEchoServer.class);
            }
        });
        context.addServlet(wsFinalHolder, FINAL_PATH);
        ServletHolder wsDelayedHolder = new ServletHolder("ws-delayed", (Servlet)new WebSocketServlet(){

            public void configure(WebSocketServletFactory factory) {
                factory.setCreator((req, resp) -> {
                    System.out.println("Received WebSocket upgrade request for /delayed");
                    try {
                        Thread.sleep(TestWebSocketServer.this.handshakeDelayMillis);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    System.out.println("After delay, accepting WebSocket connection for /delayed");
                    return new TestWebsocketEchoServer();
                });
            }
        });
        context.addServlet(wsDelayedHolder, DELAYED_PATH);
        this.jettyServer.setHandler((Handler)context);
        this.jettyServer.start();
    }

    public void stop() throws Exception {
        if (this.jettyServer != null) {
            this.jettyServer.stop();
            this.jettyServer.join();
        }
    }
}

