/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service;

import com.mulesoft.service.http.impl.service.HostNameIpsRing;
import com.mulesoft.service.http.impl.service.HostNameResolver;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Every;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.reflections.ReflectionUtils;

@Feature(value="HTTP EE Service")
@Story(value="DNS Resolution")
public class DomainNameResolverTestCase
extends AbstractMuleTestCase {
    private static final String TEST_HOST = System.getProperty("domainNameResolver.test.host", "salesforce.com");
    private static final String UNKNOWN_TEST_HOST = System.getProperty("domainNameResolver.test.unknownHost", "unknown.mulesoft.unknown");

    @BeforeClass
    public static void validateTestHost() throws UnknownHostException {
        Assert.assertThat((String)(TEST_HOST + " doesn't resolve to at least 2 different ips and is no good for this test."), (Object)InetAddress.getAllByName(TEST_HOST).length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(1)));
    }

    @BeforeClass
    public static void validateUnknownTestHost() {
        try {
            InetAddress.getAllByName(UNKNOWN_TEST_HOST);
            Assert.fail((String)(UNKNOWN_TEST_HOST + " could be resolved when it has to be unresolvable/unknown."));
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    @Test
    public void allIpsResolved() throws UnknownHostException {
        HostNameResolver resolver = new HostNameResolver();
        Assert.assertThat((Object)resolver.getAddresses(TEST_HOST), (Matcher)IsCollectionWithSize.hasSize((int)InetAddress.getAllByName(TEST_HOST).length));
    }

    @Test(expected=UnknownHostException.class)
    public void unknownHost() throws UnknownHostException {
        HostNameResolver resolver = new HostNameResolver();
        resolver.getAddresses(UNKNOWN_TEST_HOST);
    }

    @Test
    public void cycleAllIps() throws UnknownHostException {
        HostNameResolver resolver = new HostNameResolver();
        for (int i = 0; i < resolver.getAddresses(TEST_HOST).size(); ++i) {
            Assert.assertThat((Object)resolver.getAddresses(TEST_HOST), (Matcher)Every.everyItem((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue(InetAddress.class))));
        }
    }

    @Test
    public void ringCounterOverflow() throws UnknownHostException {
        HostNameResolver resolver = new HostNameResolver(hostName -> {
            HostNameIpsRing hostNameIpsRing = new HostNameIpsRing(hostName);
            Field next = (Field)ReflectionUtils.getFields(HostNameIpsRing.class, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)"idxAddresses")}).iterator().next();
            next.setAccessible(true);
            try {
                ((AtomicInteger)next.get(hostNameIpsRing)).set(Integer.MAX_VALUE);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
            return hostNameIpsRing;
        });
        List resolvedAddresses = resolver.getAddresses(TEST_HOST);
        Assert.assertThat((String)resolvedAddresses.toString(), (Object)resolvedAddresses, (Matcher)IsCollectionWithSize.hasSize((Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(InetAddress.getAllByName(TEST_HOST).length))));
    }

    @Test
    public void nonRotatedIpAddresses() throws UnknownHostException {
        HostNameResolver resolver = new HostNameResolver();
        List l1 = resolver.getAddresses(TEST_HOST);
        List l2 = resolver.getAddresses(TEST_HOST);
        Assert.assertThat((Object)l2, (Matcher)Is.is((Object)l1));
    }

    @Test
    public void rotatedAddress() throws UnknownHostException {
        HostNameResolver resolver = new HostNameResolver();
        List l1 = resolver.getRotatedAddresses(TEST_HOST);
        List l2 = resolver.getRotatedAddresses(TEST_HOST);
        Assert.assertThat((Object)l2, (Matcher)IsCollectionWithSize.hasSize((int)l2.size()));
        Assert.assertThat((Object)l2, (Matcher)CoreMatchers.not((Object)l1));
        ArrayList<InetAddress> l1mutable = new ArrayList<InetAddress>(l1);
        l1mutable.add((InetAddress)l1mutable.remove(0));
        Assert.assertThat(l1mutable, (Matcher)Is.is((Object)l2));
        l1mutable.add((InetAddress)l1mutable.remove(0));
        Assert.assertThat(l1mutable, (Matcher)Is.is((Object)resolver.getRotatedAddresses(TEST_HOST)));
    }

    @Test
    public void nonRotateWithRotateIpAddresses() throws UnknownHostException {
        HostNameResolver resolver = new HostNameResolver();
        List l1 = resolver.getAddresses(TEST_HOST);
        List l2 = resolver.getRotatedAddresses(TEST_HOST);
        Assert.assertThat((Object)l2, (Matcher)Is.is((Object)l1));
    }
}

