/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketFrame;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
public class TestWebsocketEchoServer
extends WebSocketAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestWebsocketEchoServer.class);
    private Session session;

    @OnWebSocketClose
    public void onWebSocketClose(int statusCode, String reason) {
        LOGGER.info("Close: statusCode = " + statusCode + ", reason=" + reason);
    }

    @OnWebSocketError
    public void onWebSocketError(Throwable cause) {
        LOGGER.error("Error: " + cause.getMessage());
    }

    @OnWebSocketConnect
    public void onWebSocketConnect(Session sess) {
        this.session = sess;
        LOGGER.info("Connect: " + this.session.getRemoteAddress().getAddress());
    }

    @OnWebSocketMessage
    public void onWebSocketText(String message) {
        try {
            LOGGER.info("Websocket Echo server received: '{}'", (Object)message);
            this.session.getRemote().sendString(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @OnWebSocketFrame
    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        try {
            this.session.getRemote().sendBytes(ByteBuffer.wrap(payload, offset, len));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

