/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.http.api.ws.WebSocket;

public abstract class AbstractNettyWebSocket
implements WebSocket {
    private boolean isSendingFragmented = false;
    private final List<String> groups = new ArrayList<String>();

    protected AbstractNettyWebSocket() {
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void addGroup(String group) {
        this.groups.add(group);
    }

    public void removeGroup(String group) {
        this.groups.remove(group);
    }

    public CompletableFuture<Void> sendFrame(byte[] frameBytes) {
        Object frame;
        boolean isLast = this.isLast(frameBytes[0]);
        boolean isText = this.isText(frameBytes[0]);
        int actualLength = frameBytes.length - 1;
        if (isText) {
            String text = new String(frameBytes, 1, actualLength, StandardCharsets.UTF_8);
            frame = this.isSendingFragmented ? new ContinuationWebSocketFrame(isLast, 0, text) : new TextWebSocketFrame(isLast, 0, text);
        } else {
            byte[] data = new byte[actualLength];
            System.arraycopy(frameBytes, 1, data, 0, actualLength);
            frame = this.isSendingFragmented ? new ContinuationWebSocketFrame(isLast, 0, Unpooled.wrappedBuffer((byte[])data)) : new BinaryWebSocketFrame(isLast, 0, Unpooled.wrappedBuffer((byte[])data));
        }
        this.isSendingFragmented = !isLast;
        return this.sendFrame((WebSocketFrame)frame);
    }

    public byte[] toTextFrame(String data, boolean last) {
        byte[] dataAsBytes = data.getBytes(StandardCharsets.UTF_8);
        byte[] encoded = new byte[dataAsBytes.length + 1];
        encoded[0] = this.getFirstByte(true, last);
        System.arraycopy(dataAsBytes, 0, encoded, 1, dataAsBytes.length);
        return encoded;
    }

    public byte[] toBinaryFrame(byte[] data, boolean last) {
        byte[] encoded = new byte[data.length + 1];
        encoded[0] = this.getFirstByte(false, last);
        System.arraycopy(data, 0, encoded, 1, data.length);
        return encoded;
    }

    private byte getFirstByte(boolean isText, boolean isLast) {
        int lastMask = isLast ? 1 : 0;
        int textMask = isText ? 2 : 0;
        return (byte)(lastMask | textMask);
    }

    private boolean isText(byte b) {
        return (2 & b) != 0;
    }

    private boolean isLast(byte b) {
        return (1 & b) != 0;
    }

    protected abstract CompletableFuture<Void> sendFrame(WebSocketFrame var1);
}

