/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.functional.ws;

import com.mulesoft.service.http.impl.service.client.ws.OutboundWebSocket;
import com.mulesoft.service.http.impl.service.client.ws.reconnect.OutboundWebSocketReconnectionHandler;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.websocket.GrizzlyWebSocketAdapter;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mule.runtime.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketProtocol;

@RunWith(value=MockitoJUnitRunner.class)
public class OutboundSocketReconnectionTestCase {
    @Mock
    private AsyncHttpProviderConfig httpProviderConfig;
    @Mock
    private ProtocolHandler protocolHandler;
    @Mock
    private OutboundWebSocketReconnectionHandler reconnectionHandler;
    @Mock
    private org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate retryPolicyTemplate;
    @Mock
    private Scheduler scheduler;
    private CompletableFuture<WebSocket> reconnectionFuture = new CompletableFuture();
    private GrizzlyWebSocketAdapter adapter;
    private OutboundWebSocket socket;

    @Before
    public void before() {
        this.adapter = GrizzlyWebSocketAdapter.newInstance((AsyncHttpProviderConfig)this.httpProviderConfig, (ProtocolHandler)this.protocolHandler);
        this.socket = new OutboundWebSocket("id", URI.create("http://mulesoft.com"), WebSocketProtocol.WS, this.adapter, this.reconnectionHandler);
        Mockito.when((Object)this.reconnectionHandler.reconnect(this.socket, (RetryPolicyTemplate)this.retryPolicyTemplate, this.scheduler)).thenReturn(this.reconnectionFuture);
    }

    @Test
    public void reconnectsTwiceSerially() throws Exception {
        CompletableFuture firstFuture = this.socket.reconnect(this.retryPolicyTemplate, this.scheduler);
        ((OutboundWebSocketReconnectionHandler)Mockito.verify((Object)this.reconnectionHandler)).reconnect(this.socket, (RetryPolicyTemplate)this.retryPolicyTemplate, this.scheduler);
        WebSocket newSocket = (WebSocket)Mockito.mock(WebSocket.class);
        this.reconnectionFuture.complete(newSocket);
        Assert.assertThat(firstFuture.get(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)newSocket)));
        Mockito.reset((Object[])new OutboundWebSocketReconnectionHandler[]{this.reconnectionHandler});
        this.reconnectionFuture = new CompletableFuture();
        Mockito.when((Object)this.reconnectionHandler.reconnect(this.socket, (RetryPolicyTemplate)this.retryPolicyTemplate, this.scheduler)).thenReturn(this.reconnectionFuture);
        CompletableFuture secondFuture = this.socket.reconnect(this.retryPolicyTemplate, this.scheduler);
        Assert.assertThat((Object)secondFuture, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.sameInstance(this.reconnectionFuture))));
        ((OutboundWebSocketReconnectionHandler)Mockito.verify((Object)this.reconnectionHandler)).reconnect(this.socket, (RetryPolicyTemplate)this.retryPolicyTemplate, this.scheduler);
    }

    @Test
    public void concurrentReconnectionReturnSameFuture() throws Exception {
        CopyOnWriteArrayList futures = new CopyOnWriteArrayList();
        int top = 5;
        CountDownLatch latch = new CountDownLatch(5);
        for (int i = 0; i < top; i = (int)((short)(i + 1))) {
            new Thread(() -> {
                futures.add(this.socket.reconnect(this.retryPolicyTemplate, this.scheduler));
                latch.countDown();
            }).start();
        }
        Assert.assertThat((Object)latch.await(5L, TimeUnit.SECONDS), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat(futures, (Matcher)Matchers.hasSize((int)top));
        Assert.assertThat((Object)futures.stream().allMatch(f -> f == futures.get(0)), (Matcher)CoreMatchers.is((Object)true));
    }
}

