/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty.frame;

import com.mulesoft.service.http.impl.netty.frame.FrameCodec;
import com.mulesoft.service.http.impl.netty.frame.WebSocketFrameMatcher;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class FrameCodecTestCase
extends AbstractMuleTestCase {
    @Test
    public void testEncodeDecode() {
        FrameCodec frameCodec = new FrameCodec();
        TextWebSocketFrame original = new TextWebSocketFrame(true, 0, "Hello World");
        byte[] encoded = frameCodec.encode((WebSocketFrame)original);
        WebSocketFrame decoded = frameCodec.decode(encoded);
        MatcherAssert.assertThat((Object)decoded, WebSocketFrameMatcher.aFrameSimilarTo((WebSocketFrame)original));
        MatcherAssert.assertThat((Object)ByteBufUtil.getBytes((ByteBuf)decoded.content()), (Matcher)Matchers.is((Object)"Hello World".getBytes(StandardCharsets.UTF_8)));
    }

    @Test
    public void testWithFragmentation() {
        FrameCodec frameCodec = new FrameCodec();
        TextWebSocketFrame first = new TextWebSocketFrame(false, 0, "Hello ");
        ContinuationWebSocketFrame second = new ContinuationWebSocketFrame(true, 0, "world!");
        byte[] firstEncoded = frameCodec.encode((WebSocketFrame)first);
        byte[] secondEncoded = frameCodec.encode((WebSocketFrame)second);
        WebSocketFrame firstDecoded = frameCodec.decode(firstEncoded);
        WebSocketFrame secondDecoded = frameCodec.decode(secondEncoded);
        MatcherAssert.assertThat((Object)firstDecoded, WebSocketFrameMatcher.aFrameSimilarTo((WebSocketFrame)first));
        MatcherAssert.assertThat((Object)secondDecoded, WebSocketFrameMatcher.aFrameSimilarTo((WebSocketFrame)second));
        byte[] concat = this.concatContents(firstDecoded, secondDecoded);
        MatcherAssert.assertThat((Object)concat, (Matcher)Matchers.is((Object)"Hello world!".getBytes(StandardCharsets.UTF_8)));
    }

    private byte[] concatContents(WebSocketFrame ... frames) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (WebSocketFrame frame : frames) {
            baos.writeBytes(ByteBufUtil.getBytes((ByteBuf)frame.content()));
        }
        return baos.toByteArray();
    }
}

