/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client;

import com.mulesoft.service.http.impl.service.EEHttpServiceImplementation;
import com.mulesoft.service.http.impl.service.client.EEGrizzlyHttpClient;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Feature(value="HTTP Service")
@Story(value="Responses")
@Issue(value="W-13754230")
public class EEGrizzlyHttpClientTestCase
extends AbstractHttpClientTestCase {
    public static final String FIRST_PATH = "/first";
    public static final String REDIRECT_PATH = "/redirect";
    public static final String LOCATION_HEADER = "Location";
    private String payloadAfterDancing;
    private static final Logger LOGGER = LoggerFactory.getLogger(EEGrizzlyHttpClientTestCase.class);

    public EEGrizzlyHttpClientTestCase(String serviceToLoad) {
        super(EEHttpServiceImplementation.class.getName());
    }

    public HttpResponse setUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder response = HttpResponse.builder();
        if (request.getUri().getPath().equals(FIRST_PATH)) {
            return ((HttpResponseBuilder)response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.TEMPORARY_REDIRECT.getStatusCode())).addHeader(LOCATION_HEADER, REDIRECT_PATH)).build();
        }
        return response.statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode())).build();
    }

    protected String getUri() {
        return "http://127.0.0.1:" + this.port.getValue();
    }

    public HttpRequest getRequest() {
        return HttpRequest.builder().method(HttpConstants.Method.GET).uri(this.getUri() + FIRST_PATH).build();
    }

    public HttpRequestOptions getOptions() {
        return HttpRequestOptions.builder().responseTimeout(3000).build();
    }

    @Test
    public void handleRedirecStreaming() throws IOException {
        this.testRedirect(new HttpClientConfiguration.Builder().setName("streaming-test").build(), false);
    }

    @Test
    public void handleRedirectNoStreaming() throws IOException {
        this.testRedirect(new HttpClientConfiguration.Builder().setStreaming(true).setName("no-streaming-test").build(), false);
    }

    @Test
    public void handleRedirectAsync() throws IOException {
        this.testRedirect(new HttpClientConfiguration.Builder().setName("async-test").build(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRedirect(HttpClientConfiguration httpClientConfiguration, boolean async) {
        EEGrizzlyHttpClient client = (EEGrizzlyHttpClient)this.service.getClientFactory().create(httpClientConfiguration);
        client.start();
        try {
            HttpResponse response = null;
            response = async ? (HttpResponse)client.sendAsync(this.getRequest(), this.getOptions()).get() : client.send(this.getRequest(), this.getOptions());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            MatcherAssert.assertThat((Object)client.getRequestBuildersSize(), (Matcher)Matchers.equalTo((Object)0));
        }
        catch (Exception e) {
            Assert.fail();
        }
        finally {
            client.stop();
        }
    }
}

