/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.mule.runtime.http.api.server.ws.WebSocketConnectionHandler;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;

public class TestWebSocketConnectionHandler
implements WebSocketConnectionHandler {
    private final Map<WebSocketRequest, String> requestToSocketId = new HashMap<WebSocketRequest, String>();
    private final BlockingQueue<WebSocketCloseCode> closeCodes = new LinkedBlockingDeque<WebSocketCloseCode>();
    private final BlockingQueue<String> closeReasons = new LinkedBlockingDeque<String>();

    public String getSocketId(WebSocketRequest request) {
        return this.requestToSocketId.get(request);
    }

    public void onConnect(WebSocket socket, WebSocketRequest request) {
        this.requestToSocketId.put(request, socket.getId());
    }

    public void onClose(WebSocket socket, WebSocketRequest request, WebSocketCloseCode closeCode, String reason) {
        this.requestToSocketId.remove(request);
        try {
            this.closeCodes.put(closeCode);
            this.closeReasons.put(reason);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public WebSocketCloseCode getCloseCode() throws InterruptedException {
        return this.closeCodes.take();
    }

    public String getCloseReason() throws InterruptedException {
        return this.closeReasons.take();
    }
}

