/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty;

import com.mulesoft.service.http.impl.netty.AbstractNettyWebSocket;
import com.mulesoft.service.http.impl.netty.frame.InputStreamFramer;
import com.mulesoft.service.http.impl.service.ws.WebSocketUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.mule.runtime.http.api.ws.WebSocketProtocol;
import org.mule.runtime.http.api.ws.exception.WebSocketConnectionException;

public class NettyInboundWebSocket
extends AbstractNettyWebSocket {
    private final String socketId;
    private final URI requestUri;
    private final ChannelHandlerContext ctx;
    private final WebSocketHandler webSocketHandler;
    private final AtomicBoolean closed;
    private final WebSocketRequest request;

    public NettyInboundWebSocket(String socketId, WebSocketRequest request, ChannelHandlerContext ctx, WebSocketHandler webSocketHandler) {
        this.socketId = socketId;
        this.requestUri = request.getRequestUri();
        this.request = request;
        this.ctx = ctx;
        this.webSocketHandler = webSocketHandler;
        this.closed = new AtomicBoolean(false);
    }

    public String getId() {
        return this.socketId;
    }

    public WebSocket.WebSocketType getType() {
        return WebSocket.WebSocketType.INBOUND;
    }

    public WebSocketProtocol getProtocol() {
        return this.request.getScheme();
    }

    public URI getUri() {
        return this.requestUri;
    }

    public boolean supportsReconnection() {
        return false;
    }

    public CompletableFuture<WebSocket> reconnect(RetryPolicyTemplate retryPolicyTemplate, Scheduler scheduler) {
        return WebSocketUtils.failedFuture(new UnsupportedOperationException());
    }

    public CompletableFuture<WebSocket> reconnect(org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate retryPolicyTemplate, Scheduler scheduler) {
        return this.reconnect((RetryPolicyTemplate)retryPolicyTemplate, scheduler);
    }

    public CompletableFuture<Void> send(InputStream content, MediaType mediaType) {
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.isClosed()) {
            future.completeExceptionally((Throwable)new WebSocketConnectionException((WebSocket)this));
            return future;
        }
        boolean isText = MediaTypeUtils.isStringRepresentable((MediaType)mediaType);
        try {
            new InputStreamFramer(content, new InputStreamFramer.WebSocketFrameCallback(){

                @Override
                public void onWebSocketFrame(WebSocketFrame frame) {
                    NettyInboundWebSocket.this.ctx.writeAndFlush((Object)frame);
                }

                @Override
                public void onStreamConsumed() {
                    future.complete(null);
                }
            }, isText).requestAllFrames();
        }
        catch (IOException e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public CompletableFuture<Void> close(WebSocketCloseCode code, String reason) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        CloseWebSocketFrame closeFrame = new CloseWebSocketFrame(code.getProtocolCode(), reason);
        this.ctx.writeAndFlush((Object)closeFrame).addListener(ignored -> {
            if (this.closed.compareAndSet(false, true)) {
                this.webSocketHandler.getConnectionHandler().onClose((WebSocket)this, this.request, code, reason);
            }
            future.complete(null);
        });
        return future;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isConnected() {
        return !this.closed.get();
    }

    @Override
    protected CompletableFuture<Void> sendFrame(WebSocketFrame frame) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.ctx.writeAndFlush((Object)frame).addListener(r -> future.complete(null));
        return future;
    }
}

