/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty;

import com.mulesoft.service.http.impl.netty.NettyOutboundWebSocket;
import com.mulesoft.service.http.impl.netty.NettyOutboundWebSocketsProvider;
import com.mulesoft.service.http.impl.service.ws.WebSocketUtils;
import io.netty.handler.ssl.SslContext;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.ws.WebSocket;

public class NettyOutboundWebSocketReconnectionHandler {
    private final NettyOutboundWebSocketsProvider wsProvider;
    private final HttpRequest request;
    private final HttpRequestOptions requestOptions;
    private final String socketId;
    private final WebSocketCallback callback;
    private final SslContext sslContext;

    public NettyOutboundWebSocketReconnectionHandler(NettyOutboundWebSocketsProvider wsProvider, HttpRequest request, HttpRequestOptions requestOptions, String socketId, WebSocketCallback callback, SslContext sslContext) {
        this.wsProvider = wsProvider;
        this.request = request;
        this.requestOptions = requestOptions;
        this.socketId = socketId;
        this.callback = callback;
        this.sslContext = sslContext;
    }

    public CompletableFuture<WebSocket> reconnect(NettyOutboundWebSocket webSocket, RetryPolicyTemplate retryPolicyTemplate, Scheduler scheduler) {
        return retryPolicyTemplate.applyPolicy(() -> this.wsProvider.openWebSocket(this.request, this.requestOptions, this.socketId, this.callback, this.sslContext), t -> !webSocket.isClosed(), t -> {}, t -> {}, t -> WebSocketUtils.mapWsException(t, webSocket), scheduler);
    }
}

