/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty.frame;

import com.mulesoft.service.http.impl.netty.frame.InputStreamFramer;
import com.mulesoft.service.http.impl.netty.frame.WebSocketFrameMatcher;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.qameta.allure.Issue;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Issue(value="W-16381954")
public class InputStreamFramerTestCase
extends AbstractMuleTestCase {
    private static final String TEST_PAYLOAD = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.";

    @Test
    public void emptyText() throws Exception {
        TestFramesConsumer consumer = new TestFramesConsumer();
        ByteArrayInputStream payload = new ByteArrayInputStream(new byte[0]);
        InputStreamFramer framer = new InputStreamFramer((InputStream)payload, (InputStreamFramer.WebSocketFrameCallback)consumer, true, TEST_PAYLOAD.length());
        framer.requestAllFrames();
        MatcherAssert.assertThat((Object)consumer.isCompleted(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(consumer.getFrames(), (Matcher)Matchers.contains(WebSocketFrameMatcher.aFinalTextFrame()));
        MatcherAssert.assertThat((Object)consumer.getAggregatedText(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void textInOnlyOneFrame() throws Exception {
        TestFramesConsumer consumer = new TestFramesConsumer();
        ByteArrayInputStream payload = new ByteArrayInputStream(TEST_PAYLOAD.getBytes());
        InputStreamFramer framer = new InputStreamFramer((InputStream)payload, (InputStreamFramer.WebSocketFrameCallback)consumer, true, TEST_PAYLOAD.length());
        framer.requestAllFrames();
        MatcherAssert.assertThat((Object)consumer.isCompleted(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(consumer.getFrames(), (Matcher)Matchers.contains(WebSocketFrameMatcher.aFinalTextFrame()));
        MatcherAssert.assertThat((Object)consumer.getAggregatedText(), (Matcher)Matchers.is((Object)TEST_PAYLOAD));
    }

    @Test
    public void textInTwoFrames() throws Exception {
        TestFramesConsumer consumer = new TestFramesConsumer();
        ByteArrayInputStream payload = new ByteArrayInputStream(TEST_PAYLOAD.getBytes());
        InputStreamFramer framer = new InputStreamFramer((InputStream)payload, (InputStreamFramer.WebSocketFrameCallback)consumer, true, TEST_PAYLOAD.length() - 10);
        framer.requestAllFrames();
        MatcherAssert.assertThat((Object)consumer.isCompleted(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(consumer.getFrames(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{WebSocketFrameMatcher.aNonFinalTextFrame(), WebSocketFrameMatcher.aFinalContinuationFrame()}));
        MatcherAssert.assertThat((Object)consumer.getAggregatedText(), (Matcher)Matchers.is((Object)TEST_PAYLOAD));
    }

    @Test
    public void textInTwoFramesRequestingInSeveralParts() throws Exception {
        TestFramesConsumer consumer = new TestFramesConsumer();
        ByteArrayInputStream payload = new ByteArrayInputStream(TEST_PAYLOAD.getBytes());
        InputStreamFramer framer = new InputStreamFramer((InputStream)payload, (InputStreamFramer.WebSocketFrameCallback)consumer, true, TEST_PAYLOAD.length() - 10);
        framer.requestFrames(0L);
        MatcherAssert.assertThat((Object)consumer.isCompleted(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(consumer.getFrames(), (Matcher)Matchers.empty());
        framer.requestFrames(1L);
        MatcherAssert.assertThat((Object)consumer.isCompleted(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat(consumer.getFrames(), (Matcher)Matchers.contains(WebSocketFrameMatcher.aNonFinalTextFrame()));
        framer.requestFrames(1L);
        MatcherAssert.assertThat((Object)consumer.isCompleted(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat(consumer.getFrames(), (Matcher)Matchers.contains((Matcher[])new Matcher[]{WebSocketFrameMatcher.aNonFinalTextFrame(), WebSocketFrameMatcher.aFinalContinuationFrame()}));
        MatcherAssert.assertThat((Object)consumer.getAggregatedText(), (Matcher)Matchers.is((Object)TEST_PAYLOAD));
    }

    @Test
    public void cancellationClosesTheStream() throws Exception {
        TestFramesConsumer consumer = new TestFramesConsumer();
        InputStream payload = (InputStream)Mockito.mock(InputStream.class);
        InputStreamFramer framer = new InputStreamFramer(payload, (InputStreamFramer.WebSocketFrameCallback)consumer, true);
        framer.cancel();
        ((InputStream)Mockito.verify((Object)payload)).close();
    }

    private static class TestFramesConsumer
    implements InputStreamFramer.WebSocketFrameCallback {
        private final List<WebSocketFrame> frames = new ArrayList<WebSocketFrame>();
        private boolean isCompleted = false;

        private TestFramesConsumer() {
        }

        public void onWebSocketFrame(WebSocketFrame frame) {
            this.frames.add(frame);
        }

        public void onStreamConsumed() {
            this.isCompleted = true;
        }

        public boolean isCompleted() {
            return this.isCompleted;
        }

        public List<WebSocketFrame> getFrames() {
            return this.frames;
        }

        public String getAggregatedText() {
            StringBuilder sb = new StringBuilder();
            for (WebSocketFrame frame : this.frames) {
                sb.append(new String(ByteBufUtil.getBytes((ByteBuf)frame.content())));
            }
            return sb.toString();
        }
    }
}

