/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.util;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketExternalClient
extends ExternalResource {
    private WebSocketClient jettyClient;
    private Session session;
    private TestWebSocketsClient apiClient;

    protected void before() throws Throwable {
        this.jettyClient = new WebSocketClient();
        this.jettyClient.start();
    }

    protected void after() {
        try {
            this.jettyClient.stop();
            if (this.session != null && this.session.isOpen()) {
                this.session.close(1000, "Goodbye");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void connect(URI uri) throws Exception {
        this.apiClient = new TestWebSocketsClient();
        this.session = (Session)this.jettyClient.connect((Object)this.apiClient, uri).get();
    }

    public void sendText(String text) {
        if (this.session == null) {
            throw new IllegalStateException("Test websocket client is not connected");
        }
        this.session.getRemote().sendStringByFuture(text);
    }

    public void sendPartialText(String text, boolean isFinal) throws IOException {
        if (this.session == null) {
            throw new IllegalStateException("Test websocket client is not connected");
        }
        this.session.getRemote().sendPartialString(text, isFinal);
    }

    public void sendBytes(byte[] buf) throws IOException {
        if (this.session == null) {
            throw new IllegalStateException("Test websocket client is not connected");
        }
        this.session.getRemote().sendBytes(ByteBuffer.wrap(buf));
    }

    public void close(int statusCode, String reason) {
        this.session.close(statusCode, reason);
    }

    public String takeStringMessage() throws InterruptedException {
        return this.apiClient.takeTextMessage();
    }

    public byte[] takeBinaryMessage() throws InterruptedException {
        return this.apiClient.takeBinaryMessage();
    }

    @WebSocket
    public static class TestWebSocketsClient {
        private static final Logger LOGGER = LoggerFactory.getLogger(TestWebSocketsClient.class);
        private final LinkedBlockingDeque<String> textsQueue = new LinkedBlockingDeque();
        private final LinkedBlockingDeque<byte[]> binariesQueue = new LinkedBlockingDeque();
        private final AtomicBoolean closed = new AtomicBoolean(false);

        @OnWebSocketClose
        public void onClose(int statusCode, String reason) {
            LOGGER.info("WebSocket Close: statusCode [{}], reason [{}]", (Object)statusCode, (Object)reason);
            this.closed.set(true);
        }

        @OnWebSocketConnect
        public void onConnect(Session session) {
            LOGGER.info("WebSocket Open: {}", (Object)session);
            this.closed.set(false);
        }

        @OnWebSocketError
        public void onError(Throwable cause) {
            LOGGER.error("WebSocket Error", cause);
            this.closed.set(true);
        }

        @OnWebSocketMessage
        public void onText(String message) {
            LOGGER.info("Text Message [{}]", (Object)message);
            this.textsQueue.offer(message);
        }

        @OnWebSocketMessage
        public void onBinary(byte[] payload, int offset, int len) {
            LOGGER.info("Binary Message [{}]", (Object)new String(payload, offset, len, StandardCharsets.UTF_8));
            byte[] message = new byte[len];
            System.arraycopy(payload, offset, message, 0, len);
            this.binariesQueue.offer(message);
        }

        public String takeTextMessage() throws InterruptedException {
            do {
                String polled;
                if ((polled = this.textsQueue.poll(500L, TimeUnit.MILLISECONDS)) == null) continue;
                return polled;
            } while (!this.closed.get());
            throw new IllegalStateException("Test websocket client is closed");
        }

        public byte[] takeBinaryMessage() throws InterruptedException {
            do {
                byte[] polled;
                if ((polled = this.binariesQueue.poll(500L, TimeUnit.MILLISECONDS)) == null) continue;
                return polled;
            } while (!this.closed.get());
            throw new IllegalStateException("Test websocket client is closed");
        }
    }
}

