/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.util;

import com.mulesoft.service.http.impl.util.TestWebsocketEchoServer;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.junit.rules.ExternalResource;

public class WebSocketExternalServer
extends ExternalResource {
    private final int portNumber;
    private final List<String> pathsToHandle;
    protected Server jettyServer;
    private final LinkedBlockingDeque<HttpServletRequest> upgradeRequestsQueue = new LinkedBlockingDeque();

    public WebSocketExternalServer(int portNumber, String ... pathsToHandle) {
        this.portNumber = portNumber;
        this.pathsToHandle = Arrays.stream(pathsToHandle).collect(Collectors.toList());
    }

    public void addPath(String path) {
        this.pathsToHandle.add(path);
    }

    protected void before() throws Throwable {
        this.jettyServer = new Server(this.portNumber);
        TestWebSocketHandler wsHandler = new TestWebSocketHandler();
        this.jettyServer.setHandler((Handler)wsHandler);
        this.jettyServer.start();
    }

    protected void after() {
        try {
            if (this.jettyServer != null) {
                this.jettyServer.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HttpServletRequest takeUpgradeRequest() throws InterruptedException {
        return this.upgradeRequestsQueue.take();
    }

    private class TestWebSocketHandler
    extends WebSocketHandler {
        private TestWebSocketHandler() {
        }

        public void configure(WebSocketServletFactory factory) {
            factory.register(TestWebsocketEchoServer.class);
            WebSocketCreator actualCreator = factory.getCreator();
            factory.setCreator((servletUpgradeRequest, servletUpgradeResponse) -> {
                String path = servletUpgradeRequest.getHttpServletRequest().getRequestURI();
                if (WebSocketExternalServer.this.pathsToHandle.contains(path)) {
                    try {
                        WebSocketExternalServer.this.upgradeRequestsQueue.put(servletUpgradeRequest.getHttpServletRequest());
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    return actualCreator.createWebSocket(servletUpgradeRequest, servletUpgradeResponse);
                }
                return null;
            });
        }
    }
}

