/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty;

import com.mulesoft.service.http.impl.netty.frame.FrameCodec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.http.api.ws.WebSocket;

public abstract class AbstractNettyWebSocket
implements WebSocket {
    private boolean isSendingFragmented = false;
    private final List<String> groups;
    private final LazyValue<FrameCodec> frameCodec = new LazyValue(FrameCodec::new);

    protected AbstractNettyWebSocket() {
        this.groups = new ArrayList<String>();
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public void addGroup(String group) {
        this.groups.add(group);
    }

    public void removeGroup(String group) {
        this.groups.remove(group);
    }

    public CompletableFuture<Void> sendFrame(byte[] frameBytes) {
        WebSocketFrame frame = ((FrameCodec)this.frameCodec.get()).decode(frameBytes);
        this.isSendingFragmented = !frame.isFinalFragment();
        return this.sendFrame(frame);
    }

    public byte[] toTextFrame(String data, boolean last) {
        byte[] payload = data.getBytes(StandardCharsets.UTF_8);
        return ((FrameCodec)this.frameCodec.get()).encode(this.asFrame(payload, true, !this.isSendingFragmented, last));
    }

    public byte[] toBinaryFrame(byte[] data, boolean last) {
        return ((FrameCodec)this.frameCodec.get()).encode(this.asFrame(data, false, !this.isSendingFragmented, last));
    }

    private WebSocketFrame asFrame(byte[] payload, boolean isText, boolean isFirst, boolean isLast) {
        ByteBuf byteBuf = ByteBufAllocator.DEFAULT.buffer(payload.length, payload.length).writeBytes(payload);
        if (isFirst) {
            if (isText) {
                return new TextWebSocketFrame(isLast, 0, byteBuf);
            }
            return new BinaryWebSocketFrame(isLast, 0, byteBuf);
        }
        return new ContinuationWebSocketFrame(isLast, 0, byteBuf);
    }

    protected abstract CompletableFuture<Void> sendFrame(WebSocketFrame var1);
}

