/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.functional.ws.netty;

import com.mulesoft.service.http.impl.netty.EENettyHttpServiceImplementation;
import com.mulesoft.service.http.test.util.WebSocketExternalClient;
import com.mulesoft.service.http.test.util.WebSocketExternalServer;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ws.WebSocketHandlerManager;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public abstract class AbstractNettyWebSocketTestCase
extends AbstractMuleTestCase {
    private SimpleUnitTestSupportSchedulerService schedulerService;
    protected EENettyHttpServiceImplementation service;
    protected HttpClient muleHttpClient;
    protected HttpServer muleHttpServer;
    @Rule
    public DynamicPort mulePort = new DynamicPort("muleServerPort");
    @Rule
    public DynamicPort externalPort = new DynamicPort("jettyServerPort");
    @Rule
    public WebSocketExternalServer externalServer = new WebSocketExternalServer(this.externalPort.getNumber());
    @Rule
    public WebSocketExternalClient externalClient = new WebSocketExternalClient();
    protected WebSocketHandlerManager handlerManager;

    @Before
    public void setUp() throws Exception {
        this.schedulerService = new SimpleUnitTestSupportSchedulerService();
        this.service = new EENettyHttpServiceImplementation((SchedulerService)this.schedulerService);
        this.service.start();
        this.muleHttpServer = this.service.getServerFactory().create(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.mulePort.getNumber()).setName("ws-test").build());
        this.muleHttpServer.start();
        this.muleHttpClient = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("ws").build());
        this.muleHttpClient.start();
    }

    @After
    public void tearDown() throws Exception {
        if (this.handlerManager != null) {
            this.handlerManager.stop();
            this.handlerManager.dispose();
        }
        if (this.muleHttpClient != null) {
            this.muleHttpClient.stop();
        }
        if (this.muleHttpServer != null) {
            this.muleHttpServer.stop();
            this.muleHttpServer.dispose();
        }
        if (this.service != null) {
            this.service.stop();
        }
        if (this.schedulerService != null) {
            this.schedulerService.stop();
        }
    }
}

