/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.functional.ws.netty;

import com.mulesoft.service.http.impl.functional.ws.netty.AbstractNettyWebSocketTestCase;
import com.mulesoft.service.http.test.util.TestWebSocketConnectionHandler;
import com.mulesoft.service.http.test.util.TestWebSocketHandler;
import io.qameta.allure.Issue;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import org.eclipse.jetty.websocket.api.exceptions.UpgradeException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.StringContains;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketMessageHandler;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;

public class NettyWebSocketServerTestCase
extends AbstractNettyWebSocketTestCase {
    private static final int TEST_SERVER_TIMEOUT = 1000;
    private TestWebSocketConnectionHandler connectionHandler;

    @Before
    public void registerWebSocketHandler() {
        this.connectionHandler = new TestWebSocketConnectionHandler();
        WebSocketMessageHandler echoMessageHandler = message -> message.getSocket().send((InputStream)message.getContent().getValue(), message.getContent().getDataType().getMediaType());
        TestWebSocketHandler echoHandler = new TestWebSocketHandler("/echo", this.connectionHandler, echoMessageHandler, 1000L);
        this.muleHttpServer.addWebSocketHandler((WebSocketHandler)echoHandler);
    }

    @Test
    public void echoTextRequestFromExternalClient() throws Exception {
        String testText = "Hello echo!";
        URI uri = URI.create("ws://localhost:" + this.mulePort.getNumber() + "/echo");
        this.externalClient.connect(uri);
        this.externalClient.sendText("Hello echo!");
        String receivedMessage = this.externalClient.takeStringMessage();
        MatcherAssert.assertThat((Object)receivedMessage, (Matcher)Matchers.is((Object)"Hello echo!"));
    }

    @Test
    @Issue(value="W-16381954")
    public void echoTextRequestFromExternalClientInTwoParts() throws Exception {
        String part1 = "Hello ";
        String part2 = "echo ";
        String part3 = "server!";
        URI uri = URI.create("ws://localhost:" + this.mulePort.getNumber() + "/echo");
        this.externalClient.connect(uri);
        this.externalClient.sendPartialText("Hello ", false);
        this.externalClient.sendPartialText("echo ", false);
        this.externalClient.sendPartialText("server!", true);
        String receivedMessage = this.externalClient.takeStringMessage();
        MatcherAssert.assertThat((Object)receivedMessage, (Matcher)Matchers.is((Object)"Hello echo server!"));
    }

    @Test
    public void echoBinaryRequestFromExternalClient() throws Exception {
        byte[] testBinary = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
        URI uri = URI.create("ws://localhost:" + this.mulePort.getNumber() + "/echo");
        this.externalClient.connect(uri);
        this.externalClient.sendBytes((byte[])testBinary.clone());
        byte[] receivedMessage = this.externalClient.takeBinaryMessage();
        MatcherAssert.assertThat((Object)receivedMessage, (Matcher)Matchers.is((Object)testBinary));
    }

    @Test
    public void externalClientRequestsANonWebSocketPath() {
        URI uri = URI.create("ws://localhost:" + this.mulePort.getNumber() + "/notFound");
        ExecutionException executionException = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> this.externalClient.connect(uri));
        MatcherAssert.assertThat((Object)executionException.getCause(), (Matcher)Matchers.instanceOf(UpgradeException.class));
        MatcherAssert.assertThat((Object)executionException.getCause().getMessage(), (Matcher)StringContains.containsString((String)"Failed to upgrade to websocket: Unexpected HTTP Response Status Code: 503 Service Unavailable"));
    }

    @Test
    @Issue(value="W-16264925")
    public void externalClientClosesConnection() throws Exception {
        URI uri = URI.create("ws://localhost:" + this.mulePort.getNumber() + "/echo");
        this.externalClient.connect(uri);
        this.externalClient.close(1001, "Goodbye blue sky");
        WebSocketCloseCode closeCode = this.connectionHandler.getCloseCode();
        String closeReason = this.connectionHandler.getCloseReason();
        MatcherAssert.assertThat((Object)closeCode, (Matcher)Matchers.is((Object)WebSocketCloseCode.fromProtocolCode((int)1001)));
        MatcherAssert.assertThat((Object)closeReason, (Matcher)Matchers.is((Object)"Goodbye blue sky"));
    }

    @Test
    public void serverTimeout() throws Exception {
        URI uri = URI.create("ws://localhost:" + this.mulePort.getNumber() + "/echo");
        this.externalClient.connect(uri);
        WebSocketCloseCode closeCode = this.connectionHandler.getCloseCode();
        String closeReason = this.connectionHandler.getCloseReason();
        MatcherAssert.assertThat((Object)closeCode, (Matcher)Matchers.is((Object)WebSocketCloseCode.NORMAL_CLOSURE));
        MatcherAssert.assertThat((Object)closeReason, (Matcher)Matchers.is((Object)"Timeout"));
    }
}

