/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.grizzly.memory.manager;

import com.mulesoft.service.http.impl.grizzly.memory.manager.HeapBuffer;
import com.mulesoft.service.http.impl.grizzly.memory.manager.MuleGrizzlyHeapMemoryManager;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.threadpool.FixedThreadPool;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="HTTP EE Service")
@Story(value="Memory Management")
public class MuleGrizzlyHeapMemoryManagerTestCase
extends AbstractMuleTestCase {
    private static final int MAX_BUFFER_SIZE = 10;
    private static FixedThreadPool grizzlyPool;
    private static final MuleGrizzlyHeapMemoryManager memoryManager;

    @BeforeClass
    public static void setUp() throws Exception {
        grizzlyPool = new FixedThreadPool(ThreadPoolConfig.defaultConfig().setMemoryManager((MemoryManager)memoryManager).setPoolName(MuleGrizzlyHeapMemoryManagerTestCase.class.getSimpleName() + "Pool").setCorePoolSize(1).setMaxPoolSize(2));
    }

    @AfterClass
    public static void tearDown() throws Exception {
        grizzlyPool.shutdown();
    }

    @Test
    public void allocOutsideWorkerAlsoWorks() {
        HeapBuffer buffer = memoryManager.allocate(10);
        buffer.position(3);
        buffer.trim();
        MatcherAssert.assertThat((Object)buffer.position(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void neverAllocatesDirect() {
        MatcherAssert.assertThat((Object)memoryManager.willAllocateDirect(9), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)memoryManager.willAllocateDirect(11), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void hasMonitoringProbe() {
        MatcherAssert.assertThat((Object)memoryManager.getMonitoringConfig(), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void biggerThanMax() throws ExecutionException, InterruptedException {
        grizzlyPool.submit(() -> {
            HeapBuffer buffer = memoryManager.allocateAtLeast(11);
            MatcherAssert.assertThat((Object)buffer.capacity(), (Matcher)Matchers.is((Object)11));
        }).get();
    }

    @Test
    public void reallocateToSmaller() throws ExecutionException, InterruptedException {
        grizzlyPool.submit(() -> {
            HeapBuffer oldBuffer = memoryManager.allocateAtLeast(10);
            HeapBuffer newBuffer = memoryManager.reallocate(oldBuffer, 9);
            MatcherAssert.assertThat((Object)newBuffer, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)oldBuffer)));
        }).get();
    }

    @Test
    public void reallocateToBigger() throws ExecutionException, InterruptedException {
        grizzlyPool.submit(() -> {
            HeapBuffer oldBuffer = memoryManager.allocateAtLeast(10);
            HeapBuffer newBuffer = memoryManager.reallocate(oldBuffer, 11);
            MatcherAssert.assertThat((Object)newBuffer, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)oldBuffer))));
        }).get();
    }

    @Test
    public void releaseBufferClears() throws ExecutionException, InterruptedException {
        grizzlyPool.submit(() -> {
            HeapBuffer buffer = memoryManager.allocateAtLeast(10);
            buffer.position(3);
            memoryManager.release(buffer);
            MatcherAssert.assertThat((Object)buffer.position(), (Matcher)Matchers.is((Object)0));
        }).get();
    }

    @Test
    public void wrapByteArray() throws ExecutionException, InterruptedException {
        grizzlyPool.submit(() -> {
            HeapBuffer buffer1 = memoryManager.wrap("0123456789".getBytes());
            MatcherAssert.assertThat((Object)buffer1.toStringContent(), (Matcher)Matchers.is((Object)"0123456789"));
            HeapBuffer buffer2 = memoryManager.wrap("0123456789".getBytes(), 2, 3);
            MatcherAssert.assertThat((Object)buffer2.toStringContent(), (Matcher)Matchers.is((Object)"234"));
        }).get();
    }

    @Test
    public void wrapString() throws ExecutionException, InterruptedException {
        grizzlyPool.submit(() -> {
            HeapBuffer buffer = memoryManager.wrap("0123456789");
            MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"0123456789"));
        }).get();
    }

    @Test
    public void wrapByteBuffer() throws ExecutionException, InterruptedException {
        grizzlyPool.submit(() -> {
            ByteBuffer nioBuffer = memoryManager.wrap("0123456789").toByteBuffer();
            Buffer buffer1 = memoryManager.wrap(nioBuffer);
            MatcherAssert.assertThat((Object)buffer1.toStringContent(), (Matcher)Matchers.is((Object)"0123456789"));
            ByteBuffer readOnlyBuffer = nioBuffer.asReadOnlyBuffer();
            Buffer buffer2 = memoryManager.wrap(readOnlyBuffer);
            MatcherAssert.assertThat((Object)buffer2.toStringContent(), (Matcher)Matchers.is((Object)"0123456789"));
        }).get();
    }

    @Test
    public void smallBuffer() throws ExecutionException, InterruptedException {
        grizzlyPool.submit(() -> memoryManager.allocate(9)).get();
    }

    @Test
    public void reuseTheSame() throws ExecutionException, InterruptedException {
        grizzlyPool.submit(() -> {
            HeapBuffer oldBuffer = memoryManager.allocateHeapBuffer(10);
            oldBuffer.dispose();
            HeapBuffer newBuffer = memoryManager.allocate(10);
            MatcherAssert.assertThat((Object)newBuffer, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)oldBuffer)));
        }).get();
    }

    @Test
    public void cacheReadOnly() throws ExecutionException, InterruptedException {
        grizzlyPool.submit(() -> {
            ByteBuffer readOnlyBuffer = memoryManager.wrap("0123456789").toByteBuffer().asReadOnlyBuffer();
            Buffer buffer1 = memoryManager.wrap(readOnlyBuffer);
            buffer1.dispose();
            Buffer buffer2 = memoryManager.wrap(readOnlyBuffer);
            MatcherAssert.assertThat((Object)buffer2, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)buffer1)));
        }).get();
    }

    @Test
    public void cacheWithByteBuffer() throws ExecutionException, InterruptedException {
        grizzlyPool.submit(() -> {
            HeapBuffer oldBuffer = memoryManager.allocate(10);
            ByteBuffer byteBuffer1 = oldBuffer.toByteBuffer();
            memoryManager.release(oldBuffer);
            HeapBuffer newBuffer = memoryManager.allocate(10);
            ByteBuffer byteBuffer2 = newBuffer.toByteBuffer();
            MatcherAssert.assertThat((Object)byteBuffer2, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)byteBuffer1)));
        }).get();
    }

    @Test
    public void releaseLastAndNotLastAllocated() throws ExecutionException, InterruptedException {
        grizzlyPool.submit(() -> {
            HeapBuffer bigBuffer = memoryManager.allocate(2048);
            bigBuffer.position(2000);
            HeapBuffer smallBuffer = memoryManager.allocate(10);
            HeapBuffer lastBuffer = memoryManager.allocate(10);
            memoryManager.release(bigBuffer);
            memoryManager.release(smallBuffer);
            memoryManager.release(lastBuffer);
        }).get();
    }

    @Test
    public void trimBigAndSmallBuffers() throws ExecutionException, InterruptedException {
        grizzlyPool.submit(() -> {
            HeapBuffer bigBuffer = memoryManager.allocate(2048);
            bigBuffer.position(2000);
            HeapBuffer smallBuffer = memoryManager.allocate(10);
            bigBuffer.trim();
            smallBuffer.trim();
        }).get();
    }

    static {
        memoryManager = new MuleGrizzlyHeapMemoryManager(10);
    }
}

