/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.grizzly.memory.manager;

import com.mulesoft.service.http.impl.grizzly.memory.manager.ReadOnlyHeapBuffer;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import org.glassfish.grizzly.Buffer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="HTTP EE Service")
@Story(value="Memory Management")
public class ReadOnlyHeapBufferTestCase
extends AbstractMuleTestCase {
    @Test
    public void writeOperationsFail() {
        ReadOnlyHeapBuffer buffer = new ReadOnlyHeapBuffer("Hello world!".getBytes(), 0, 12);
        Buffer mockBuffer = (Buffer)Mockito.mock(Buffer.class);
        ByteBuffer nioByteBuffer = ByteBuffer.allocate(12);
        MatcherAssert.assertThat((Object)buffer.isReadOnly(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)buffer.asReadOnlyBuffer(), (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)buffer)));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.putChar(0, '4'));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.putShort(0, (short)4));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.put(0, (byte)45));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.putInt(0, 4));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.putLong(0, 4L));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.putFloat(0, 4.0f));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.putDouble(0, 4.0));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.put(mockBuffer, 0, 1));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.put(nioByteBuffer, 0, 1));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.put(new byte[3], 0, 1));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.putChar('4'));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.putShort((short)4));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.put((byte)45));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.putInt(4));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.putLong(4L));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.putFloat(4.0f));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.putDouble(4.0));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.put(mockBuffer));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.put(nioByteBuffer));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.put(new byte[3]));
        Assert.assertThrows(ReadOnlyBufferException.class, () -> buffer.prepend(null));
    }
}

