/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.provider;

import com.mulesoft.service.http.impl.netty.EENettyHttpServiceImplementation;
import com.mulesoft.service.http.impl.provider.EEHttpServiceProvider;
import com.mulesoft.service.http.impl.service.EEHttpServiceImplementation;
import io.qameta.allure.Issue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.service.Service;
import org.mule.service.http.impl.provider.HttpServiceProvider;
import org.mule.tck.MuleTestUtils;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class EEHttpServiceProviderTestCase
extends AbstractMuleTestCase {
    @Test
    @Issue(value="W-18952070")
    public void grizzlyPropertyByDefault() {
        MatcherAssert.assertThat((Object)HttpServiceProvider.getImplementationName(), (Matcher)Matchers.is((Object)"GRIZZLY"));
    }

    @Test
    public void grizzlyPropertyIfConfigured() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.service.implementation", (Object)"GRIZZLY", () -> MatcherAssert.assertThat((Object)HttpServiceProvider.getImplementationName(), (Matcher)Matchers.is((Object)"GRIZZLY")));
    }

    @Test
    public void nettyPropertyIfConfigured() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.service.implementation", (Object)"NETTY", () -> MatcherAssert.assertThat((Object)HttpServiceProvider.getImplementationName(), (Matcher)Matchers.is((Object)"NETTY")));
    }

    @Test
    public void invalidPropertyThrows() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.service.implementation", (Object)"INVALID", () -> Assert.assertThrows((String)"Unknown HTTP Service implementation 'INVALID'. Choose 'GRIZZLY' or 'NETTY'", IllegalArgumentException.class, HttpServiceProvider::getImplementationName));
    }

    @Test
    @Issue(value="W-18952070")
    public void grizzlyImplementationByDefault() {
        MatcherAssert.assertThat(this.getImplementationClass(), (Matcher)Matchers.is(EEHttpServiceImplementation.class));
    }

    @Test
    public void grizzlyImplementationIfConfigured() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.service.implementation", (Object)"GRIZZLY", () -> MatcherAssert.assertThat(this.getImplementationClass(), (Matcher)Matchers.is(EEHttpServiceImplementation.class)));
    }

    @Test
    public void nettyImplementationIfConfigured() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.service.implementation", (Object)"NETTY", () -> MatcherAssert.assertThat(this.getImplementationClass(), (Matcher)Matchers.is(EENettyHttpServiceImplementation.class)));
    }

    @Test
    public void invalidImplementationThrows() throws Exception {
        MuleTestUtils.testWithSystemProperty((String)"mule.http.service.implementation", (Object)"INVALID", () -> Assert.assertThrows((String)"Unknown HTTP Service implementation 'INVALID'. Choose 'GRIZZLY' or 'NETTY'", IllegalArgumentException.class, this::getImplementationClass));
    }

    public Class<? extends Service> getImplementationClass() {
        return new EEHttpServiceProvider().getServiceDefinition().getService().getClass();
    }
}

