/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client.ws;

import com.mulesoft.service.http.impl.service.client.ws.OutboundWebSocket;
import com.mulesoft.service.http.impl.service.client.ws.reconnect.OutboundWebSocketReconnectionHandler;
import com.ning.http.client.AsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.websocket.GrizzlyWebSocketAdapter;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mockito.Mockito;
import org.mule.functional.junit4.matchers.ThrowableCauseMatcher;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.mule.runtime.http.api.ws.WebSocketProtocol;
import org.mule.runtime.http.api.ws.exception.WebSocketClosedException;
import org.mule.runtime.http.api.ws.exception.WebSocketConnectionException;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class OutboundWebSocketTestCase
extends AbstractMuleTestCase {
    private GrizzlyWebSocketAdapter unusableDelegate;
    private OutboundWebSocket outboundWebSocket;
    private OutboundWebSocketReconnectionHandler reconnectionHandler;

    @Before
    public void setUp() throws Exception {
        AsyncHttpProviderConfig config = (AsyncHttpProviderConfig)Mockito.mock(AsyncHttpProviderConfig.class);
        ProtocolHandler protocolHandler = (ProtocolHandler)Mockito.mock(ProtocolHandler.class);
        this.unusableDelegate = GrizzlyWebSocketAdapter.newInstance((AsyncHttpProviderConfig)config, (ProtocolHandler)protocolHandler);
        this.reconnectionHandler = (OutboundWebSocketReconnectionHandler)Mockito.mock(OutboundWebSocketReconnectionHandler.class);
        this.outboundWebSocket = new OutboundWebSocket("ws-id", URI.create("ws://localhost:8080"), WebSocketProtocol.WS, this.unusableDelegate, this.reconnectionHandler);
    }

    @Test
    public void dummyTest() {
        MatcherAssert.assertThat((Object)this.outboundWebSocket.getProtocol(), (Matcher)Matchers.is((Object)WebSocketProtocol.WS));
        MatcherAssert.assertThat((Object)this.outboundWebSocket.getUri(), (Matcher)Matchers.is((Object)URI.create("ws://localhost:8080")));
        MatcherAssert.assertThat((Object)this.outboundWebSocket.getType(), (Matcher)Matchers.is((Object)WebSocket.WebSocketType.OUTBOUND));
        MatcherAssert.assertThat((Object)this.outboundWebSocket.isConnected(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)this.outboundWebSocket.toString(), (Matcher)Matchers.is((Object)"WebSocket Id: ws-id\nType: OUTBOUND\nURI: ws://localhost:8080"));
    }

    @Test
    public void failToSendOnClosedWebSocket() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        MatcherAssert.assertThat((Object)this.outboundWebSocket.isClosed(), (Matcher)Matchers.is((Object)false));
        this.outboundWebSocket.close(WebSocketCloseCode.NORMAL_CLOSURE, "");
        MatcherAssert.assertThat((Object)this.outboundWebSocket.isClosed(), (Matcher)Matchers.is((Object)true));
        CompletableFuture future = this.outboundWebSocket.send(inputStream, MediaType.TEXT);
        ExecutionException exception = (ExecutionException)Assert.assertThrows(ExecutionException.class, future::get);
        MatcherAssert.assertThat((Object)exception, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(WebSocketClosedException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.is((Object)"WebSocket ws-id has already been closed.")))));
        CompletableFuture future2 = this.outboundWebSocket.sendFrame("".getBytes());
        ExecutionException exception2 = (ExecutionException)Assert.assertThrows(ExecutionException.class, future2::get);
        MatcherAssert.assertThat((Object)exception2, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(WebSocketClosedException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.is((Object)"WebSocket ws-id has already been closed.")))));
    }

    @Test
    public void failToSendOnClosedDelegate() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        CompletableFuture future = this.outboundWebSocket.send(inputStream, MediaType.TEXT);
        ExecutionException exception = (ExecutionException)Assert.assertThrows(ExecutionException.class, future::get);
        MatcherAssert.assertThat((Object)exception, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(WebSocketConnectionException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.is((Object)"WebSocket ws-id connection is not usable.")))));
        CompletableFuture future2 = this.outboundWebSocket.sendFrame("".getBytes());
        ExecutionException exception2 = (ExecutionException)Assert.assertThrows(ExecutionException.class, future2::get);
        MatcherAssert.assertThat((Object)exception2, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(WebSocketConnectionException.class), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.is((Object)"WebSocket ws-id connection is not usable.")))));
    }

    @Test
    public void groupsCRUD() {
        MatcherAssert.assertThat((Object)this.outboundWebSocket.getGroups(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        this.outboundWebSocket.addGroup("group1");
        this.outboundWebSocket.addGroup("group2");
        this.outboundWebSocket.addGroup("group3");
        this.outboundWebSocket.addGroup("group3");
        this.outboundWebSocket.removeGroup("group2");
        MatcherAssert.assertThat((Object)this.outboundWebSocket.getGroups(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group3"}));
    }

    @Test
    public void equalsById() {
        OutboundWebSocket anotherWithSameId = new OutboundWebSocket("ws-id", URI.create("ws://localhost:8081"), WebSocketProtocol.WSS, this.unusableDelegate, this.reconnectionHandler);
        MatcherAssert.assertThat((Object)anotherWithSameId, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.outboundWebSocket)));
        OutboundWebSocket anotherWithDifferentId = new OutboundWebSocket("ws-id-2", URI.create("ws://localhost:8080"), WebSocketProtocol.WS, this.unusableDelegate, this.reconnectionHandler);
        MatcherAssert.assertThat((Object)anotherWithDifferentId, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.outboundWebSocket))));
        MatcherAssert.assertThat((Object)this.outboundWebSocket, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo(null))));
    }

    @Test
    public void hashCodeTest() {
        MatcherAssert.assertThat((Object)this.outboundWebSocket.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"ws-id".hashCode())));
    }
}

