/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.test.util;

import com.mulesoft.service.http.test.util.TestWebsocketEchoServer;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.websocket.server.JettyWebSocketServlet;
import org.eclipse.jetty.websocket.server.JettyWebSocketServletFactory;
import org.eclipse.jetty.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.junit.rules.ExternalResource;

public class WebSocketExternalServer
extends ExternalResource {
    private static final String CONTEXT_PATH = "/";
    private static final List<String> pathsToHandle = Arrays.asList("/wsEcho");
    private static final LinkedBlockingDeque<HttpServletRequest> upgradeRequestsQueue = new LinkedBlockingDeque();
    private final int portNumber;
    protected Server jettyServer;

    public WebSocketExternalServer(int portNumber) {
        this.portNumber = portNumber;
    }

    protected void before() throws Throwable {
        this.jettyServer = new Server(this.portNumber);
        ServletContextHandler wsHandler = new ServletContextHandler(1);
        wsHandler.setContextPath(CONTEXT_PATH);
        for (String pathToHandle : pathsToHandle) {
            wsHandler.addServlet(TestWebSocketHandler.class, pathToHandle);
        }
        wsHandler.addServlet(TestNotWebSocketHandler.class, "/notFound");
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)wsHandler, null);
        this.jettyServer.setHandler((Handler)wsHandler);
        this.jettyServer.start();
    }

    protected void after() {
        upgradeRequestsQueue.clear();
        try {
            if (this.jettyServer != null) {
                this.jettyServer.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HttpServletRequest takeUpgradeRequest() throws InterruptedException {
        return upgradeRequestsQueue.take();
    }

    public static class TestWebSocketHandler
    extends JettyWebSocketServlet {
        public void configure(JettyWebSocketServletFactory factory) {
            for (String pathToHandle : pathsToHandle) {
                factory.addMapping(pathToHandle, (servletUpgradeRequest, servletUpgradeResponse) -> {
                    try {
                        upgradeRequestsQueue.put(servletUpgradeRequest.getHttpServletRequest());
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    return new TestWebsocketEchoServer();
                });
            }
        }
    }

    public static class TestNotWebSocketHandler
    extends JettyWebSocketServlet {
        public void configure(JettyWebSocketServletFactory factory) {
            factory.setCreator((servletUpgradeRequest, servletUpgradeResponse) -> null);
        }
    }
}

