/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl;

import com.github.peterwippermann.junit4.parameterizedsuite.ParameterContext;
import com.mulesoft.service.http.impl.TestEEHttpServiceImplementation;
import com.mulesoft.service.http.impl.grizzly.memory.manager.MuleGrizzlyHeapMemoryManager;
import com.mulesoft.service.http.impl.service.EEHttpServiceImplementation;
import io.qameta.allure.Description;
import io.qameta.allure.Story;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.DisplayName;
import org.junit.runners.Parameterized;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.service.http.impl.functional.client.AbstractHttpClientTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Story(value="Memory Management")
@DisplayName(value="Validates that the memory management injected is being used.")
public class HttpMemoryManagementTestCase
extends AbstractHttpClientTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(EEHttpServiceImplementation.class);
    public static final String GRIZZLY_DEFAULT_MEMORY_MANAGEMENT_PROPERTY = "org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER";
    @Rule
    public SystemProperty grizzlyMemoryManagement = new SystemProperty("org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER", MuleGrizzlyHeapMemoryManager.class.getName());
    @Rule
    public MockitoRule mockitorule = MockitoJUnit.rule();
    private HttpClient client;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> params() {
        if (ParameterContext.isParameterSet()) {
            return Collections.singletonList((Object[])ParameterContext.getParameter(Object[].class));
        }
        return Collections.singletonList(new String[]{TestEEHttpServiceImplementation.class.getName()});
    }

    public HttpMemoryManagementTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    protected HttpResponse setUpHttpResponse(HttpRequest request) {
        HttpResponseBuilder responseBuilder = HttpResponse.builder();
        responseBuilder.statusCode(Integer.valueOf(HttpConstants.HttpStatus.OK.getStatusCode()));
        return responseBuilder.build();
    }

    @Before
    public void createClient() {
        this.client = this.service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("no-body-test").build());
        this.client.start();
    }

    @After
    public void stopClient() {
        if (this.client != null) {
            this.client.stop();
        }
    }

    @Test
    public void byteBufferInvoked() throws Exception {
        this.assertEmptyOnStatus("/noContent", HttpConstants.HttpStatus.OK);
        MatcherAssert.assertThat((Object)((TestEEHttpServiceImplementation)this.service).getAllocatedBytes(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)0)));
    }

    @Test
    @Description(value="In some tests, the http service is stopped and restarted. The service should be able to be restarted.")
    public void verifyServiceStopAndStart() throws Exception {
        ((TestEEHttpServiceImplementation)this.service).stop();
        ((TestEEHttpServiceImplementation)this.service).start();
    }

    private void assertEmptyOnStatus(String path, HttpConstants.HttpStatus expectedStatus) throws IOException, TimeoutException {
        HttpResponse response = this.client.send(HttpRequest.builder().uri(this.getUri() + path).build());
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.is((Object)expectedStatus.getStatusCode()));
        MatcherAssert.assertThat((Object)response.getEntity().getBytesLength().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)response.getEntity().getBytesLength().getAsLong(), (Matcher)Matchers.is((Object)0L));
    }
}

