/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.functional.ws;

import com.mulesoft.service.http.impl.provider.EEHttpServiceProvider;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.runtime.http.api.server.ws.WebSocketHandlerManager;
import org.mule.tck.SimpleUnitTestSupportSchedulerService;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public abstract class AbstractWebSocketTestCase
extends AbstractMuleTestCase {
    private static SimpleUnitTestSupportSchedulerService schedulerService;
    protected static HttpService service;
    protected static HttpClient client;
    protected static HttpServer server;
    @ClassRule
    public static DynamicPort port;
    protected WebSocketHandlerManager handlerManager;

    @BeforeClass
    public static void setupClass() throws Exception {
        schedulerService = new SimpleUnitTestSupportSchedulerService();
        EEHttpServiceProvider eeHttpServiceProvider = new EEHttpServiceProvider();
        eeHttpServiceProvider.setSchedulerService((SchedulerService)schedulerService);
        service = (HttpService)eeHttpServiceProvider.getServiceDefinition().getService();
        ((Startable)service).start();
        server = service.getServerFactory().create(new HttpServerConfiguration.Builder().setHost("localhost").setPort(port.getNumber()).setName("ws-test").build());
        server.start();
        client = service.getClientFactory().create(new HttpClientConfiguration.Builder().setName("ws").build());
        client.start();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        if (client != null) {
            client.stop();
        }
        if (server != null) {
            server.stop();
            server.dispose();
        }
        if (service != null) {
            ((Stoppable)service).stop();
        }
        if (schedulerService != null) {
            schedulerService.stop();
        }
    }

    @After
    public void after() {
        if (this.handlerManager != null) {
            this.handlerManager.stop();
            this.handlerManager.dispose();
        }
    }

    static {
        port = new DynamicPort("port");
    }
}

