/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.grizzly.memory.manager;

import com.mulesoft.service.http.impl.grizzly.memory.manager.Bits;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="HTTP EE Service")
@Story(value="Memory Management")
public class BitsTestCase
extends AbstractMuleTestCase {
    @Test
    public void testChars() {
        byte aLo = Bits.char0((char)'a');
        byte aHi = Bits.char1((char)'a');
        char a = Bits.makeChar((byte)aHi, (byte)aLo);
        MatcherAssert.assertThat((Object)Character.valueOf(a), (Matcher)Matchers.is((Object)Character.valueOf('a')));
        char aBigEndian = Bits.getChar((byte[])new byte[]{aHi, aLo}, (int)0, (boolean)true);
        MatcherAssert.assertThat((Object)Character.valueOf(aBigEndian), (Matcher)Matchers.is((Object)Character.valueOf('a')));
        char aLittleEndian = Bits.getChar((byte[])new byte[]{aLo, aHi}, (int)0, (boolean)false);
        MatcherAssert.assertThat((Object)Character.valueOf(aLittleEndian), (Matcher)Matchers.is((Object)Character.valueOf('a')));
        byte[] array = new byte[4];
        Bits.putChar((byte[])array, (int)0, (char)aBigEndian, (boolean)true);
        Bits.putChar((byte[])array, (int)2, (char)aLittleEndian, (boolean)false);
        MatcherAssert.assertThat((Object)Character.valueOf(Bits.getChar((byte[])array, (int)0, (boolean)true)), (Matcher)Matchers.is((Object)Character.valueOf('a')));
        MatcherAssert.assertThat((Object)Character.valueOf(Bits.getChar((byte[])array, (int)2, (boolean)false)), (Matcher)Matchers.is((Object)Character.valueOf('a')));
    }

    @Test
    public void testShorts() {
        short theShort = 300;
        byte short0 = Bits.short0((short)theShort);
        byte short1 = Bits.short1((short)theShort);
        short madeShort = Bits.makeShort((byte)short1, (byte)short0);
        MatcherAssert.assertThat((Object)madeShort, (Matcher)Matchers.is((Object)theShort));
        short shortBigEndian = Bits.getShort((byte[])new byte[]{short1, short0}, (int)0, (boolean)true);
        MatcherAssert.assertThat((Object)shortBigEndian, (Matcher)Matchers.is((Object)theShort));
        short shortLittleEndian = Bits.getShort((byte[])new byte[]{short0, short1}, (int)0, (boolean)false);
        MatcherAssert.assertThat((Object)shortLittleEndian, (Matcher)Matchers.is((Object)theShort));
        byte[] array = new byte[4];
        Bits.putShort((byte[])array, (int)0, (short)shortBigEndian, (boolean)true);
        Bits.putShort((byte[])array, (int)2, (short)shortLittleEndian, (boolean)false);
        MatcherAssert.assertThat((Object)Bits.getShort((byte[])array, (int)0, (boolean)true), (Matcher)Matchers.is((Object)theShort));
        MatcherAssert.assertThat((Object)Bits.getShort((byte[])array, (int)2, (boolean)false), (Matcher)Matchers.is((Object)theShort));
    }

    @Test
    public void testInts() {
        int theInt = 300;
        byte int0 = Bits.int0((int)theInt);
        byte int1 = Bits.int1((int)theInt);
        byte int2 = Bits.int2((int)theInt);
        byte int3 = Bits.int3((int)theInt);
        int madeInt = Bits.makeInt((byte)int3, (byte)int2, (byte)int1, (byte)int0);
        MatcherAssert.assertThat((Object)madeInt, (Matcher)Matchers.is((Object)theInt));
        int intBigEndian = Bits.getInt((byte[])new byte[]{int3, int2, int1, int0}, (int)0, (boolean)true);
        MatcherAssert.assertThat((Object)intBigEndian, (Matcher)Matchers.is((Object)theInt));
        int intLittleEndian = Bits.getInt((byte[])new byte[]{int0, int1, int2, int3}, (int)0, (boolean)false);
        MatcherAssert.assertThat((Object)intLittleEndian, (Matcher)Matchers.is((Object)theInt));
        byte[] array = new byte[8];
        Bits.putInt((byte[])array, (int)0, (int)intBigEndian, (boolean)true);
        Bits.putInt((byte[])array, (int)4, (int)intLittleEndian, (boolean)false);
        MatcherAssert.assertThat((Object)Bits.getInt((byte[])array, (int)0, (boolean)true), (Matcher)Matchers.is((Object)theInt));
        MatcherAssert.assertThat((Object)Bits.getInt((byte[])array, (int)4, (boolean)false), (Matcher)Matchers.is((Object)theInt));
    }

    @Test
    public void testLong() {
        long theLong = 300L;
        byte long0 = Bits.long0((long)theLong);
        byte long1 = Bits.long1((long)theLong);
        byte long2 = Bits.long2((long)theLong);
        byte long3 = Bits.long3((long)theLong);
        byte long4 = Bits.long4((long)theLong);
        byte long5 = Bits.long5((long)theLong);
        byte long6 = Bits.long6((long)theLong);
        byte long7 = Bits.long7((long)theLong);
        long madeLong = Bits.makeLong((byte)long7, (byte)long6, (byte)long5, (byte)long4, (byte)long3, (byte)long2, (byte)long1, (byte)long0);
        MatcherAssert.assertThat((Object)madeLong, (Matcher)Matchers.is((Object)theLong));
        long longBigEndian = Bits.getLong((byte[])new byte[]{long7, long6, long5, long4, long3, long2, long1, long0}, (int)0, (boolean)true);
        MatcherAssert.assertThat((Object)longBigEndian, (Matcher)Matchers.is((Object)theLong));
        long longLittleEndian = Bits.getLong((byte[])new byte[]{long0, long1, long2, long3, long4, long5, long6, long7}, (int)0, (boolean)false);
        MatcherAssert.assertThat((Object)longLittleEndian, (Matcher)Matchers.is((Object)theLong));
        byte[] array = new byte[16];
        Bits.putLong((byte[])array, (int)0, (long)longBigEndian, (boolean)true);
        Bits.putLong((byte[])array, (int)8, (long)longLittleEndian, (boolean)false);
        MatcherAssert.assertThat((Object)Bits.getLong((byte[])array, (int)0, (boolean)true), (Matcher)Matchers.is((Object)theLong));
        MatcherAssert.assertThat((Object)Bits.getLong((byte[])array, (int)8, (boolean)false), (Matcher)Matchers.is((Object)theLong));
    }
}

