/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.grizzly.memory.manager;

import com.mulesoft.service.http.impl.grizzly.memory.manager.Bits;
import com.mulesoft.service.http.impl.grizzly.memory.manager.HeapBuffer;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.memory.BufferArray;
import org.glassfish.grizzly.memory.ByteBufferArray;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.mule.tck.junit4.AbstractMuleTestCase;

@Feature(value="HTTP EE Service")
@Story(value="Memory Management")
public class HeapBufferTestCase
extends AbstractMuleTestCase {
    @Test
    public void heapBufferProperties() {
        String testPayload = "Test payload";
        HeapBuffer buffer = HeapBuffer.wrap((byte[])testPayload.getBytes());
        MatcherAssert.assertThat((Object)buffer.isComposite(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)buffer.isDirect(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)buffer.isExternal(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)buffer.hasArray(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void readOnly() {
        String testPayload = "Test payload";
        HeapBuffer buffer = HeapBuffer.wrap((byte[])testPayload.getBytes());
        MatcherAssert.assertThat((Object)buffer.isReadOnly(), (Matcher)Matchers.is((Object)false));
        HeapBuffer readOnlyBuffer = buffer.asReadOnlyBuffer();
        MatcherAssert.assertThat((Object)readOnlyBuffer.isReadOnly(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)readOnlyBuffer.compareTo((Buffer)buffer), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)readOnlyBuffer.equals((Object)buffer), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void bufferToStringContent() {
        String testPayload = "Test payload";
        HeapBuffer buffer = HeapBuffer.wrap((byte[])testPayload.getBytes());
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)testPayload));
        MatcherAssert.assertThat((Object)buffer.toStringContent(Charset.defaultCharset()), (Matcher)Matchers.is((Object)testPayload));
        MatcherAssert.assertThat((Object)buffer.toStringContent(null), (Matcher)Matchers.is((Object)testPayload));
    }

    @Test
    public void bufferToString() {
        String testPayload = "Test payload";
        HeapBuffer buffer = HeapBuffer.wrap((byte[])testPayload.getBytes());
        MatcherAssert.assertThat((Object)buffer.toString(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"HeapBuffer ("), (Matcher)Matchers.containsString((String)") [pos=0 lim=12 cap=12]")));
    }

    @Test
    public void prependDoesNothing() {
        HeapBuffer original = HeapBuffer.wrap((byte[])"payload".getBytes());
        HeapBuffer toPrepend = HeapBuffer.wrap((byte[])"Test ".getBytes());
        HeapBuffer result = original.prepend((Buffer)toPrepend);
        MatcherAssert.assertThat((Object)result.toStringContent(), (Matcher)Matchers.is((Object)"payload"));
    }

    @Test
    public void prependOnDisposedBufferFails() {
        HeapBuffer original = HeapBuffer.wrap((byte[])"payload".getBytes());
        HeapBuffer toPrepend = HeapBuffer.wrap((byte[])"Test ".getBytes());
        original.dispose();
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> original.prepend((Buffer)toPrepend));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"HeapBuffer has already been disposed"));
    }

    @Test
    public void checkDisposeFailsForDisposedBuffer() {
        HeapBuffer disposed = HeapBuffer.wrap((byte[])"Disposed".getBytes());
        disposed.checkDispose();
        disposed.dispose();
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> ((HeapBuffer)disposed).checkDispose());
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"HeapBuffer has already been disposed"));
    }

    @Test
    public void trimJustFlipsTheBuffer() {
        HeapBuffer original = HeapBuffer.wrap((byte[])"Test payload".getBytes());
        original.trim();
        MatcherAssert.assertThat((Object)original.toStringContent(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void shrinkDoesNothing() {
        HeapBuffer original = HeapBuffer.wrap((byte[])"Test payload".getBytes());
        original.shrink();
        MatcherAssert.assertThat((Object)original.toStringContent(), (Matcher)Matchers.is((Object)"Test payload"));
    }

    @Test
    public void dumpHexToStringBuilder() {
        StringBuilder sb = new StringBuilder();
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"Test payload".getBytes());
        buffer.dumpHex((Appendable)sb);
        MatcherAssert.assertThat((Object)sb.toString(), (Matcher)Matchers.containsString((String)"54 65  73 74  20 70  61 79    6c 6f  61 64"));
    }

    @Test
    public void toNioByteBuffer() {
        byte[] bytes = "Test payload".getBytes();
        HeapBuffer original = HeapBuffer.wrap((byte[])bytes);
        ByteBuffer copied = original.toByteBuffer();
        MatcherAssert.assertThat((Object)copied.array(), (Matcher)Matchers.is((Object)bytes));
        ByteBuffer underlying = original.underlying();
        MatcherAssert.assertThat((Object)underlying.array(), (Matcher)Matchers.is((Object)bytes));
    }

    @Test
    public void allowBufferDispose() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"Test payload".getBytes());
        MatcherAssert.assertThat((Object)buffer.allowBufferDispose(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)buffer.tryDispose(), (Matcher)Matchers.is((Object)false));
        buffer.checkDispose();
        MatcherAssert.assertThat((Object)buffer.release(), (Matcher)Matchers.is((Object)false));
        buffer.checkDispose();
        buffer.allowBufferDispose(true);
        MatcherAssert.assertThat((Object)buffer.allowBufferDispose(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)buffer.tryDispose(), (Matcher)Matchers.is((Object)true));
        Assert.assertThrows(IllegalStateException.class, () -> ((HeapBuffer)buffer).checkDispose());
        MatcherAssert.assertThat((Object)buffer.array(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        MatcherAssert.assertThat((Object)buffer.arrayOffset(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void compareBuffers() {
        HeapBuffer buffer1 = HeapBuffer.wrap((byte[])"1".getBytes());
        HeapBuffer buffer1bis = HeapBuffer.wrap((byte[])"1".getBytes());
        HeapBuffer buffer2 = HeapBuffer.wrap((byte[])"2".getBytes());
        MatcherAssert.assertThat((Object)buffer1.compareTo((Buffer)buffer1bis), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)buffer1.compareTo((Buffer)buffer2), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)buffer2.compareTo((Buffer)buffer1), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void useAsHashMapKey() {
        HeapBuffer key = HeapBuffer.wrap((byte[])"1".getBytes());
        HeapBuffer equalToKey = HeapBuffer.wrap((byte[])"1".getBytes());
        HeapBuffer anotherKey = HeapBuffer.wrap((byte[])"2".getBytes());
        HashMap<HeapBuffer, String> map = new HashMap<HeapBuffer, String>();
        map.put(key, "TheValue");
        MatcherAssert.assertThat((Object)map.containsKey(equalToKey), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((String)map.get(equalToKey)), (Matcher)Matchers.is((Object)"TheValue"));
        MatcherAssert.assertThat((Object)map.containsKey(anotherKey), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void slice() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        HeapBuffer result = buffer.slice(3, 8);
        MatcherAssert.assertThat((Object)result.toStringContent(), (Matcher)Matchers.is((Object)"34567"));
        MatcherAssert.assertThat((Object)result.capacity(), (Matcher)Matchers.is((Object)5));
        HeapBuffer copy = buffer.slice();
        MatcherAssert.assertThat((Object)copy.toStringContent(), (Matcher)Matchers.is((Object)"0123456789"));
    }

    @Test
    public void duplicatedIsEqual() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        HeapBuffer duplicate = buffer.duplicate();
        MatcherAssert.assertThat((Object)buffer.compareTo((Buffer)duplicate), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)buffer, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)duplicate)));
    }

    @Test
    public void whenConsumingOneByteTheBuffersBecomeDifferent() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        HeapBuffer duplicate = buffer.duplicate();
        duplicate.get();
        MatcherAssert.assertThat((Object)buffer.compareTo((Buffer)duplicate), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)buffer, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)duplicate))));
    }

    @Test
    public void notEquals() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        HeapBuffer shifted = HeapBuffer.wrap((byte[])"1234567890".getBytes());
        String str = "0123456789";
        MatcherAssert.assertThat((Object)buffer.equals((Object)str), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)buffer.equals((Object)shifted), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void chars() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        buffer.putChar('A');
        buffer.putChar(5, 'B');
        buffer.rewind();
        MatcherAssert.assertThat((Object)Character.valueOf(buffer.getChar()), (Matcher)Matchers.is((Object)Character.valueOf('A')));
        MatcherAssert.assertThat((Object)Character.valueOf(buffer.getChar(5)), (Matcher)Matchers.is((Object)Character.valueOf('B')));
    }

    @Test
    public void floats() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789ABCDEF".getBytes());
        float oneFloat = 0.5f;
        float anotherFloat = 0.6f;
        buffer.putFloat(oneFloat);
        buffer.putFloat(7, anotherFloat);
        buffer.rewind();
        MatcherAssert.assertThat((Object)Float.valueOf(buffer.getFloat()), (Matcher)Matchers.is((Object)Float.valueOf(oneFloat)));
        MatcherAssert.assertThat((Object)Float.valueOf(buffer.getFloat(7)), (Matcher)Matchers.is((Object)Float.valueOf(anotherFloat)));
        double oneDouble = 0.7f;
        double anotherDouble = 0.8f;
        buffer.rewind();
        buffer.putDouble(oneDouble);
        buffer.putDouble(7, anotherDouble);
        buffer.rewind();
        MatcherAssert.assertThat((Object)buffer.getDouble(), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)oneDouble, (double)0.01)));
        MatcherAssert.assertThat((Object)buffer.getDouble(7), (Matcher)Matchers.is((Matcher)Matchers.closeTo((double)anotherDouble, (double)0.01)));
    }

    @Test
    public void getNumbersWithEndianness() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789ABCDEF".getBytes());
        MatcherAssert.assertThat((Object)buffer.order(), (Matcher)Matchers.is((Object)ByteOrder.BIG_ENDIAN));
        int beInt = buffer.getInt();
        int expectedBEInt = 808530483;
        MatcherAssert.assertThat((Object)beInt, (Matcher)Matchers.is((Object)expectedBEInt));
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int leInt = buffer.getInt();
        int expectedLEInt = 926299444;
        MatcherAssert.assertThat((Object)leInt, (Matcher)Matchers.is((Object)expectedLEInt));
        short leShort = buffer.getShort();
        short expectedLEShort = 14648;
        MatcherAssert.assertThat((Object)leShort, (Matcher)Matchers.is((Object)expectedLEShort));
        buffer.order(ByteOrder.BIG_ENDIAN);
        short beShort = buffer.getShort();
        short expectedBEShort = 16706;
        MatcherAssert.assertThat((Object)beShort, (Matcher)Matchers.is((Object)expectedBEShort));
        MatcherAssert.assertThat((Object)buffer.get(), (Matcher)Matchers.is((Object)67));
        char nextChar = Bits.makeChar((byte)68, (byte)69);
        MatcherAssert.assertThat((Object)Character.valueOf(buffer.getChar()), (Matcher)Matchers.is((Object)Character.valueOf(nextChar)));
    }

    @Test
    public void outOfBounds() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123".getBytes());
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.get(-1));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.get(4));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getChar(-1));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getChar(4));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getShort(-1));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getShort(4));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getInt(-1));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getInt(4));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getLong(-1));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getLong(4));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getFloat(-1));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getFloat(4));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getDouble(-1));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.getDouble(4));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.putChar(-1, '4'));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.putChar(4, '4'));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.putShort(-1, (short)4));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.putShort(4, (short)4));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.put(-1, (byte)45));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.put(4, (byte)52));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.putInt(-1, 4));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.putInt(4, 4));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.putLong(-1, 4L));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.putLong(4, 4L));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.putFloat(-1, 4.0f));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.putFloat(4, 4.0f));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.putDouble(-1, 4.0));
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.putDouble(4, 4.0));
        while (buffer.hasRemaining()) {
            buffer.get();
        }
        Assert.assertThrows(BufferUnderflowException.class, () -> ((HeapBuffer)buffer).get());
        Assert.assertThrows(BufferUnderflowException.class, () -> ((HeapBuffer)buffer).getChar());
        Assert.assertThrows(BufferUnderflowException.class, () -> ((HeapBuffer)buffer).getShort());
        Assert.assertThrows(BufferUnderflowException.class, () -> ((HeapBuffer)buffer).getInt());
        Assert.assertThrows(BufferUnderflowException.class, () -> ((HeapBuffer)buffer).getLong());
        Assert.assertThrows(BufferUnderflowException.class, () -> ((HeapBuffer)buffer).getFloat());
        Assert.assertThrows(BufferUnderflowException.class, () -> ((HeapBuffer)buffer).getDouble());
        Assert.assertThrows(BufferUnderflowException.class, () -> buffer.putChar('4'));
        Assert.assertThrows(BufferOverflowException.class, () -> buffer.put((byte)52));
        Assert.assertThrows(BufferOverflowException.class, () -> buffer.put("4".getBytes()));
        Assert.assertThrows(BufferOverflowException.class, () -> buffer.put8BitString("4"));
        Assert.assertThrows(BufferUnderflowException.class, () -> buffer.putShort((short)4));
        Assert.assertThrows(BufferUnderflowException.class, () -> buffer.putInt(4));
        Assert.assertThrows(BufferUnderflowException.class, () -> buffer.putLong(4L));
        Assert.assertThrows(BufferUnderflowException.class, () -> buffer.putFloat(4.0f));
        Assert.assertThrows(BufferUnderflowException.class, () -> buffer.putDouble(4.0));
    }

    @Test
    public void put() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789abcdef".getBytes());
        buffer.put((byte)88);
        buffer.put(6, (byte)89);
        buffer.rewind();
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"X12345Y789abcdef"));
        HeapBuffer toPut = HeapBuffer.wrap((byte[])"----------".getBytes());
        buffer.put((Buffer)toPut);
        toPut.rewind();
        Assert.assertThrows(BufferOverflowException.class, () -> buffer.put((Buffer)toPut));
        buffer.rewind();
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"----------abcdef"));
        ByteBuffer nioBuf = ByteBuffer.wrap("NIO".getBytes());
        buffer.put(nioBuf);
        buffer.position(7);
        buffer.put(nioBuf, 1, 1);
        buffer.rewind();
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"NIO----I--abcdef"));
        byte[] plain = "ban".getBytes();
        buffer.put(plain);
        buffer.put(plain, 1, 2);
        buffer.put(plain, 1, 1);
        buffer.rewind();
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"banana-I--abcdef"));
        buffer.put8BitString("some string     ");
        buffer.rewind();
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"some string     "));
        short aShort = 17786;
        int anInt = this.beInt('e', ' ', 'w', 'a');
        int longHi = this.beInt('s', ' ', 'h', 'e');
        int longLo = this.beInt('r', 'e', '!', ' ');
        long aLong = (long)longHi << 32 | (long)longLo;
        buffer.putShort(aShort).putInt(anInt).putLong(aLong);
        buffer.rewind();
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"Eze was here!   "));
        MatcherAssert.assertThat((Object)buffer.getShort(), (Matcher)Matchers.is((Object)aShort));
        MatcherAssert.assertThat((Object)buffer.getInt(), (Matcher)Matchers.is((Object)anInt));
        MatcherAssert.assertThat((Object)buffer.getLong(), (Matcher)Matchers.is((Object)aLong));
        buffer.rewind().put8BitString("some string     ");
        buffer.rewind();
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"some string     "));
        buffer.putLong(6, aLong);
        buffer.putInt(2, anInt);
        buffer.putShort(0, aShort);
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"Eze was here!   "));
        MatcherAssert.assertThat((Object)buffer.getLong(6), (Matcher)Matchers.is((Object)aLong));
        MatcherAssert.assertThat((Object)buffer.getShort(0), (Matcher)Matchers.is((Object)aShort));
        MatcherAssert.assertThat((Object)buffer.getInt(2), (Matcher)Matchers.is((Object)anInt));
    }

    int beInt(char a, char b, char c, char d) {
        return a << 24 | b << 16 | c << 8 | d;
    }

    @Test
    public void limitResetsMarkWhenLower() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        buffer.position(5);
        buffer.mark();
        buffer.limit(3);
        Assert.assertThrows(InvalidMarkException.class, () -> ((HeapBuffer)buffer).reset());
    }

    @Test
    public void positionAndMark() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"0123456789"));
        MatcherAssert.assertThat((Object)buffer.position(), (Matcher)Matchers.is((Object)0));
        buffer.position(3);
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"3456789"));
        buffer.getInt();
        MatcherAssert.assertThat((Object)buffer.position(), (Matcher)Matchers.is((Object)7));
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"789"));
        buffer.mark();
        buffer.position(2);
        Assert.assertThrows(InvalidMarkException.class, () -> ((HeapBuffer)buffer).reset());
        buffer.mark();
        buffer.position(4);
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"456789"));
        buffer.reset();
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"23456789"));
        buffer.position(0);
        buffer.limit(1);
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"0"));
    }

    @Test
    public void rewind() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        buffer.getInt();
        MatcherAssert.assertThat((Object)buffer.position(), (Matcher)Matchers.is((Object)4));
        buffer.rewind();
        MatcherAssert.assertThat((Object)buffer.position(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void split() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        Assert.assertThrows(IllegalArgumentException.class, () -> buffer.split(-1));
        Assert.assertThrows(IllegalArgumentException.class, () -> buffer.split(11));
        Buffer split = buffer.split(8);
        MatcherAssert.assertThat((Object)split.toStringContent(), (Matcher)Matchers.is((Object)"89"));
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"01234567"));
        buffer.position(5);
        buffer.mark();
        Buffer secondSplit = buffer.split(3);
        MatcherAssert.assertThat((Object)secondSplit.toStringContent(), (Matcher)Matchers.is((Object)"567"));
        secondSplit.rewind();
        MatcherAssert.assertThat((Object)secondSplit.toStringContent(), (Matcher)Matchers.is((Object)"34567"));
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)""));
        buffer.rewind();
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"012"));
        buffer.limit(1);
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"0"));
        Buffer thirdSplit = buffer.split(2);
        MatcherAssert.assertThat((Object)thirdSplit.toStringContent(), (Matcher)Matchers.is((Object)""));
    }

    @Test
    public void readToBuf() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        byte[] smallBuffer = new byte[3];
        buffer.get(smallBuffer);
        MatcherAssert.assertThat((Object)smallBuffer, (Matcher)Matchers.is((Object)"012".getBytes()));
        byte[] tooLongBuffer = new byte[30];
        Assert.assertThrows(BufferUnderflowException.class, () -> buffer.get(tooLongBuffer));
    }

    @Test
    public void readToNioBuf() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        ByteBuffer smallBuffer = ByteBuffer.allocate(3);
        buffer.get(smallBuffer);
        MatcherAssert.assertThat((Object)smallBuffer.array(), (Matcher)Matchers.is((Object)"012".getBytes()));
        ByteBuffer tooLongBuffer = ByteBuffer.allocate(30);
        Assert.assertThrows(IndexOutOfBoundsException.class, () -> buffer.get(tooLongBuffer));
        buffer.get(tooLongBuffer, 2, 2);
        MatcherAssert.assertThat((Object)tooLongBuffer.get(2), (Matcher)Matchers.is((Object)51));
        MatcherAssert.assertThat((Object)tooLongBuffer.get(3), (Matcher)Matchers.is((Object)52));
    }

    @Test
    public void compactBuffer() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        buffer.position(5);
        buffer.compact();
        MatcherAssert.assertThat((Object)buffer.toStringContent(), (Matcher)Matchers.is((Object)"56789"));
    }

    @Test
    public void debugDispose() {
        boolean oldDebugMode = HeapBuffer.DEBUG_MODE;
        HeapBuffer.DEBUG_MODE = true;
        try {
            StringHeapBuffer buffer = new StringHeapBuffer("Test");
            MatcherAssert.assertThat((Object)buffer.getDisposeStackTrace(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
            buffer.dispose();
            MatcherAssert.assertThat((Object)buffer.getDisposeStackTrace(), (Matcher)ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"HeapBuffer was disposed from")));
        }
        finally {
            HeapBuffer.DEBUG_MODE = oldDebugMode;
        }
    }

    @Test
    public void byteBufferArray() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        ByteBufferArray bufferArray1 = buffer.toByteBufferArray();
        MatcherAssert.assertThat((Object)bufferArray1.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)bufferArray1.getInitialBufferSize(0), (Matcher)Matchers.is((Object)10));
        ByteBufferArray bufferArray2 = buffer.toByteBufferArray(1, 3);
        MatcherAssert.assertThat((Object)bufferArray2.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)bufferArray2.getInitialBufferSize(0), (Matcher)Matchers.is((Object)2));
        ByteBufferArray bufferArray3 = buffer.toByteBufferArray(bufferArray2);
        MatcherAssert.assertThat((Object)bufferArray3.size(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void bufferArray() {
        HeapBuffer buffer = HeapBuffer.wrap((byte[])"0123456789".getBytes());
        BufferArray bufferArray1 = buffer.toBufferArray();
        MatcherAssert.assertThat((Object)bufferArray1.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)bufferArray1.getInitialBufferSize(0), (Matcher)Matchers.is((Object)10));
        BufferArray bufferArray2 = buffer.toBufferArray(1, 3);
        MatcherAssert.assertThat((Object)bufferArray2.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)bufferArray2.getInitialBufferSize(0), (Matcher)Matchers.is((Object)2));
        BufferArray bufferArray3 = buffer.toBufferArray(bufferArray2);
        MatcherAssert.assertThat((Object)bufferArray3.size(), (Matcher)Matchers.is((Object)2));
    }

    private static class StringHeapBuffer
    extends HeapBuffer {
        public StringHeapBuffer(String payload) {
            super(payload.getBytes(), 0, payload.length());
        }

        public Exception getDisposeStackTrace() {
            return this.disposeStackTrace;
        }
    }
}

