/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty.frame;

import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class WebSocketFrameMatcher
extends TypeSafeMatcher<WebSocketFrame> {
    private final Class<? extends WebSocketFrame> expectedType;
    private final boolean expectedIsFinal;

    public static Matcher<WebSocketFrame> aFrameSimilarTo(WebSocketFrame other) {
        return new WebSocketFrameMatcher(other.getClass(), other.isFinalFragment());
    }

    public static Matcher<WebSocketFrame> aFinalTextFrame() {
        return new WebSocketFrameMatcher(TextWebSocketFrame.class, true);
    }

    public static Matcher<WebSocketFrame> aNonFinalTextFrame() {
        return new WebSocketFrameMatcher(TextWebSocketFrame.class, false);
    }

    public static Matcher<WebSocketFrame> aFinalContinuationFrame() {
        return new WebSocketFrameMatcher(ContinuationWebSocketFrame.class, true);
    }

    WebSocketFrameMatcher(Class<? extends WebSocketFrame> expectedType, boolean expectedIsFinal) {
        this.expectedType = expectedType;
        this.expectedIsFinal = expectedIsFinal;
    }

    public void describeTo(Description description) {
        description.appendText("a ").appendText(this.expectedIsFinal ? "final" : "non-final").appendText(" frame of type ").appendText(this.expectedType.getSimpleName());
    }

    protected boolean matchesSafely(WebSocketFrame frame) {
        return this.expectedType.isInstance(frame) && frame.isFinalFragment() == this.expectedIsFinal;
    }

    protected void describeMismatchSafely(WebSocketFrame item, Description mismatchDescription) {
        if (!this.expectedType.isInstance(item)) {
            mismatchDescription.appendText("got a frame of type ").appendText(item.getClass().getSimpleName());
            return;
        }
        if (item.isFinalFragment() != this.expectedIsFinal) {
            mismatchDescription.appendText("got a ").appendText(item.isFinalFragment() ? "final" : "non-final").appendText(" frame");
        }
    }
}

