/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty.frame;

import com.mulesoft.service.http.impl.netty.frame.NettyWebSocketFrame;
import com.mulesoft.service.http.impl.netty.frame.WebSocketFramesHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.function.ThrowingRunnable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mule.runtime.api.util.IOUtils;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class WebSocketFramesHandlerTestCase
extends AbstractMuleTestCase {
    private static final ExecutorService executorService = Executors.newFixedThreadPool(1);
    private static final String TEST_METHOD_THREAD_NAME = "Expected thread name";
    private static final String TEST_PAYLOAD = "Hello world";
    private static final String TEST_PAYLOAD_1 = "Hello";
    private static final String TEST_PAYLOAD_2 = " ";
    private static final String TEST_PAYLOAD_3 = "world";
    private final LazyValue<ExecutorService> lazyScheduler = new LazyValue(() -> executorService);
    private final Latch firstFrameReceived = new Latch();
    private NettyWebSocketFrame firstFrame;
    private String threadOnFirstFrame;

    @AfterClass
    public static void tearDown() {
        executorService.shutdownNow();
    }

    @Test
    public void handleTextInOneFrame() throws IOException, InterruptedException {
        WebSocketFramesHandler handler = new WebSocketFramesHandler(this.lazyScheduler, this::onFirstFrame);
        handler.onFrame((WebSocketFrame)new TextWebSocketFrame(true, 0, TEST_PAYLOAD));
        this.firstFrameReceived.await();
        String content = new String(IOUtils.toByteArray((InputStream)((InputStream)this.firstFrame.getContent().getValue())));
        MatcherAssert.assertThat((Object)content, (Matcher)Matchers.is((Object)TEST_PAYLOAD));
        MatcherAssert.assertThat((Object)this.firstFrame.getContent().getDataType().getMediaType().toString(), (Matcher)Matchers.is((Object)"text/plain"));
    }

    @Test
    public void handleTextInThreeFrames() throws IOException, InterruptedException {
        WebSocketFramesHandler handler = new WebSocketFramesHandler(this.lazyScheduler, this::onFirstFrame);
        handler.onFrame((WebSocketFrame)new TextWebSocketFrame(false, 0, TEST_PAYLOAD_1));
        handler.onFrame((WebSocketFrame)new ContinuationWebSocketFrame(false, 0, TEST_PAYLOAD_2));
        handler.onFrame((WebSocketFrame)new ContinuationWebSocketFrame(true, 0, TEST_PAYLOAD_3));
        this.firstFrameReceived.await();
        String content = new String(IOUtils.toByteArray((InputStream)((InputStream)this.firstFrame.getContent().getValue())));
        MatcherAssert.assertThat((Object)content, (Matcher)Matchers.is((Object)TEST_PAYLOAD));
        MatcherAssert.assertThat((Object)this.firstFrame.getContent().getDataType().getMediaType().toString(), (Matcher)Matchers.is((Object)"text/plain"));
    }

    @Test
    public void handleBinaryInOneFrame() throws IOException, InterruptedException {
        WebSocketFramesHandler handler = new WebSocketFramesHandler(this.lazyScheduler, this::onFirstFrame);
        handler.onFrame((WebSocketFrame)new BinaryWebSocketFrame(true, 0, WebSocketFramesHandlerTestCase.createByteBuf(TEST_PAYLOAD.getBytes())));
        this.firstFrameReceived.await();
        String content = new String(IOUtils.toByteArray((InputStream)((InputStream)this.firstFrame.getContent().getValue())));
        MatcherAssert.assertThat((Object)content, (Matcher)Matchers.is((Object)TEST_PAYLOAD));
        MatcherAssert.assertThat((Object)this.firstFrame.getContent().getDataType().getMediaType().toString(), (Matcher)Matchers.is((Object)"application/octet-stream"));
    }

    @Test
    public void handleBinaryInThreeFrames() throws IOException, InterruptedException {
        WebSocketFramesHandler handler = new WebSocketFramesHandler(this.lazyScheduler, this::onFirstFrame);
        handler.onFrame((WebSocketFrame)new BinaryWebSocketFrame(false, 0, WebSocketFramesHandlerTestCase.createByteBuf(TEST_PAYLOAD_1.getBytes())));
        handler.onFrame((WebSocketFrame)new ContinuationWebSocketFrame(false, 0, TEST_PAYLOAD_2));
        handler.onFrame((WebSocketFrame)new ContinuationWebSocketFrame(true, 0, TEST_PAYLOAD_3));
        this.firstFrameReceived.await();
        String content = new String(IOUtils.toByteArray((InputStream)((InputStream)this.firstFrame.getContent().getValue())));
        MatcherAssert.assertThat((Object)content, (Matcher)Matchers.is((Object)TEST_PAYLOAD));
        MatcherAssert.assertThat((Object)this.firstFrame.getContent().getDataType().getMediaType().toString(), (Matcher)Matchers.is((Object)"application/octet-stream"));
        MatcherAssert.assertThat((Object)this.threadOnFirstFrame, (Matcher)Matchers.is((Matcher)Matchers.not((Object)"main")));
    }

    @Test
    public void failsIfReceivesAContinuationWithoutAPreviousFrame() {
        WebSocketFramesHandler handler = new WebSocketFramesHandler(this.lazyScheduler, this::onFirstFrame);
        ContinuationWebSocketFrame frame = new ContinuationWebSocketFrame(false, 0, TEST_PAYLOAD_2);
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> handler.onFrame((WebSocketFrame)frame));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"Received a continuation frame, but there is no sink where we can write it"));
    }

    @Test
    public void whenFirstFrameIsFinalTheCallbackIsExecutedInTheSameThread() throws Throwable {
        WebSocketFramesHandlerTestCase.withThreadName(TEST_METHOD_THREAD_NAME, () -> {
            WebSocketFramesHandler handler = new WebSocketFramesHandler(this.lazyScheduler, this::onFirstFrame);
            handler.onFrame((WebSocketFrame)new TextWebSocketFrame(true, 0, TEST_PAYLOAD_1));
            this.firstFrameReceived.await();
            MatcherAssert.assertThat((Object)this.threadOnFirstFrame, (Matcher)Matchers.is((Object)TEST_METHOD_THREAD_NAME));
        });
    }

    @Test
    public void whenFirstFrameIsNotFinalTheCallbackIsExecutedInTheProvidedScheduler() throws Throwable {
        WebSocketFramesHandlerTestCase.withThreadName(TEST_METHOD_THREAD_NAME, () -> {
            WebSocketFramesHandler handler = new WebSocketFramesHandler(this.lazyScheduler, this::onFirstFrame);
            handler.onFrame((WebSocketFrame)new TextWebSocketFrame(false, 0, TEST_PAYLOAD_1));
            this.firstFrameReceived.await();
            MatcherAssert.assertThat((Object)this.threadOnFirstFrame, (Matcher)Matchers.is((Matcher)Matchers.not((Object)TEST_METHOD_THREAD_NAME)));
        });
    }

    @Test
    public void whenSchedulerIsBusyTheCallbackIsExecutedInTheSameThread() throws Throwable {
        WebSocketFramesHandlerTestCase.withThreadName(TEST_METHOD_THREAD_NAME, () -> {
            ExecutorService busyExecutor = (ExecutorService)Mockito.mock(ExecutorService.class);
            Mockito.when(busyExecutor.submit((Runnable)ArgumentMatchers.any(Runnable.class))).thenThrow(RejectedExecutionException.class);
            WebSocketFramesHandler handler = new WebSocketFramesHandler(new LazyValue(() -> busyExecutor), this::onFirstFrame);
            handler.onFrame((WebSocketFrame)new TextWebSocketFrame(false, 0, TEST_PAYLOAD_1));
            this.firstFrameReceived.await();
            MatcherAssert.assertThat((Object)this.threadOnFirstFrame, (Matcher)Matchers.is((Object)TEST_METHOD_THREAD_NAME));
        });
    }

    @Test
    public void cancelMakesNextContinuationFail() throws IOException {
        WebSocketFramesHandler handler = new WebSocketFramesHandler(this.lazyScheduler, this::onFirstFrame);
        handler.onFrame((WebSocketFrame)new BinaryWebSocketFrame(false, 0, WebSocketFramesHandlerTestCase.createByteBuf(TEST_PAYLOAD_1.getBytes())));
        handler.cancel();
        ContinuationWebSocketFrame nextFrame = new ContinuationWebSocketFrame(false, 0, TEST_PAYLOAD_2);
        IllegalStateException exception = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> handler.onFrame((WebSocketFrame)nextFrame));
        MatcherAssert.assertThat((Object)exception.getMessage(), (Matcher)Matchers.is((Object)"Received a continuation frame, but there is no sink where we can write it"));
    }

    private void onFirstFrame(NettyWebSocketFrame firstFrame) {
        this.firstFrame = firstFrame;
        this.threadOnFirstFrame = Thread.currentThread().getName();
        this.firstFrameReceived.release();
    }

    private static ByteBuf createByteBuf(byte[] buf, int bufferSize) {
        return ByteBufAllocator.DEFAULT.buffer(bufferSize, bufferSize).writeBytes(buf, 0, bufferSize);
    }

    private static ByteBuf createByteBuf(byte[] buf) {
        return WebSocketFramesHandlerTestCase.createByteBuf(buf, buf.length);
    }

    private static void withThreadName(String threadName, ThrowingRunnable callback) throws Throwable {
        String oldThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(threadName);
        try {
            callback.run();
        }
        finally {
            Thread.currentThread().setName(oldThreadName);
        }
    }
}

