/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.service.client.ws;

import com.mulesoft.service.http.impl.service.client.ws.InboundWebSocket;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableCauseMatcher;
import org.mockito.Mockito;
import org.mule.runtime.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class InboundWebSocketTestCase
extends AbstractMuleTestCase {
    private InboundWebSocket inboundWebSocket;

    @Before
    public void setUp() {
        WebSocketHandler resource = (WebSocketHandler)Mockito.mock(WebSocketHandler.class);
        WebSocketRequest request = (WebSocketRequest)Mockito.mock(WebSocketRequest.class);
        ProtocolHandler protocolHandler = (ProtocolHandler)Mockito.mock(ProtocolHandler.class);
        HttpRequestPacket requestPacket = (HttpRequestPacket)Mockito.mock(HttpRequestPacket.class);
        this.inboundWebSocket = new InboundWebSocket("ws-id", resource, request, protocolHandler, requestPacket, new WebSocketListener[0]);
    }

    @Test
    public void doesNotSupportReconnection() {
        MatcherAssert.assertThat((Object)this.inboundWebSocket.supportsReconnection(), (Matcher)Matchers.is((Object)false));
        CompletableFuture reconnect = this.inboundWebSocket.reconnect((RetryPolicyTemplate)null, null);
        ExecutionException exception = (ExecutionException)Assert.assertThrows(ExecutionException.class, reconnect::get);
        MatcherAssert.assertThat((Object)exception, (Matcher)ThrowableCauseMatcher.hasCause((Matcher)Matchers.instanceOf(UnsupportedOperationException.class)));
    }

    @Test
    public void groupsCRUD() {
        MatcherAssert.assertThat((Object)this.inboundWebSocket.getGroups(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
        this.inboundWebSocket.addGroup("group1");
        this.inboundWebSocket.addGroup("group2");
        this.inboundWebSocket.addGroup("group3");
        this.inboundWebSocket.addGroup("group3");
        this.inboundWebSocket.removeGroup("group2");
        MatcherAssert.assertThat((Object)this.inboundWebSocket.getGroups(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"group1", "group3"}));
    }

    @Test
    public void equalsById() {
        WebSocketHandler resource = (WebSocketHandler)Mockito.mock(WebSocketHandler.class);
        WebSocketRequest request = (WebSocketRequest)Mockito.mock(WebSocketRequest.class);
        ProtocolHandler protocolHandler = (ProtocolHandler)Mockito.mock(ProtocolHandler.class);
        HttpRequestPacket requestPacket = (HttpRequestPacket)Mockito.mock(HttpRequestPacket.class);
        InboundWebSocket anotherWithSameId = new InboundWebSocket("ws-id", resource, request, protocolHandler, requestPacket, new WebSocketListener[0]);
        MatcherAssert.assertThat((Object)anotherWithSameId, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.inboundWebSocket)));
        InboundWebSocket anotherWithDifferentId = new InboundWebSocket("ws-id-2", resource, request, protocolHandler, requestPacket, new WebSocketListener[0]);
        MatcherAssert.assertThat((Object)anotherWithDifferentId, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.inboundWebSocket))));
        MatcherAssert.assertThat((Object)this.inboundWebSocket, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo(null))));
    }

    @Test
    public void string() {
        MatcherAssert.assertThat((Object)this.inboundWebSocket.toString(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)"WebSocket Id: ws-id\nType: INBOUND\nURI: null")));
    }
}

