/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.test.util;

import com.mulesoft.service.http.test.util.ws.TestWebSocketsClient;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.junit.rules.ExternalResource;

public class WebSocketExternalClient
extends ExternalResource {
    private WebSocketClient jettyClient;
    private Session session;
    private TestWebSocketsClient apiClient;

    protected void before() throws Throwable {
        this.jettyClient = new WebSocketClient();
        this.jettyClient.start();
    }

    protected void after() {
        try {
            this.jettyClient.stop();
            if (this.session != null && this.session.isOpen()) {
                this.session.close(1000, "Goodbye");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void connect(URI uri) throws Exception {
        this.apiClient = new TestWebSocketsClient();
        this.session = (Session)this.jettyClient.connect((Object)this.apiClient, uri).get();
    }

    public void sendText(String text) {
        if (this.session == null) {
            throw new IllegalStateException("Test websocket client is not connected");
        }
        this.session.getRemote().sendString(text, new WriteCallback(){

            public void writeFailed(Throwable x) {
                x.printStackTrace();
            }
        });
    }

    public void sendPartialText(String text, boolean isFinal) throws IOException {
        if (this.session == null) {
            throw new IllegalStateException("Test websocket client is not connected");
        }
        this.session.getRemote().sendPartialString(text, isFinal);
    }

    public void sendBytes(byte[] buf) throws IOException {
        if (this.session == null) {
            throw new IllegalStateException("Test websocket client is not connected");
        }
        this.session.getRemote().sendBytes(ByteBuffer.wrap(buf));
    }

    public void close(int statusCode, String reason) {
        this.session.close(statusCode, reason);
    }

    public String takeStringMessage() throws InterruptedException {
        return this.apiClient.takeTextMessage();
    }

    public byte[] takeBinaryMessage() throws InterruptedException {
        return this.apiClient.takeBinaryMessage();
    }
}

