/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty;

import com.mulesoft.service.http.impl.netty.AbstractNettyWebSocket;
import com.mulesoft.service.http.impl.netty.NettyOutboundWebSocketReconnectionHandler;
import com.mulesoft.service.http.impl.netty.frame.FramedPublisher;
import com.mulesoft.service.http.impl.netty.frame.WebSocketFramesHandler;
import com.mulesoft.service.http.impl.service.ws.WebSocketUtils;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.http.api.client.ws.WebSocketCallback;
import org.mule.runtime.http.api.ws.WebSocket;
import org.mule.runtime.http.api.ws.WebSocketCloseCode;
import org.mule.runtime.http.api.ws.WebSocketProtocol;
import org.mule.runtime.http.api.ws.exception.WebSocketClosedException;
import org.mule.runtime.http.api.ws.exception.WebSocketConnectionException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

public class NettyOutboundWebSocket
extends AbstractNettyWebSocket {
    private final WebsocketOutbound outbound;
    private final String socketId;
    private final URI uri;
    private final NettyOutboundWebSocketReconnectionHandler reconnectionHandler;
    private final AtomicBoolean closed;
    private final AtomicBoolean connected;
    private final WebSocketProtocol protocol;
    private final Lock reconnectionLock = new ReentrantLock();
    private final AtomicReference<CompletableFuture<WebSocket>> ongoingReconnection = new AtomicReference<Object>(null);

    public NettyOutboundWebSocket(WebsocketInbound inbound, WebsocketOutbound outbound, String socketId, URI uri, WebSocketCallback callback, NettyOutboundWebSocketReconnectionHandler reconnectionHandler, SslContext sslContext, LazyValue<ExecutorService> schedulerToHandleNonFinal) {
        this.outbound = outbound;
        this.socketId = socketId;
        this.uri = uri;
        this.reconnectionHandler = reconnectionHandler;
        this.closed = new AtomicBoolean(false);
        this.connected = new AtomicBoolean(true);
        inbound.receiveFrames().doOnNext(this.getFramesHandler(callback, schedulerToHandleNonFinal)).subscribe();
        inbound.receiveCloseStatus().doOnSuccess(closeStatus -> {
            WebSocketCloseCode closeCode = NettyOutboundWebSocket.getCloseCode(closeStatus);
            String closeReason = NettyOutboundWebSocket.getCloseReason(closeStatus);
            if (this.connected.compareAndSet(true, false)) {
                callback.onClose((WebSocket)this, closeCode, closeReason);
            }
        }).subscribe();
        this.protocol = sslContext != null ? WebSocketProtocol.WSS : WebSocketProtocol.WS;
    }

    private Consumer<WebSocketFrame> getFramesHandler(WebSocketCallback callback, LazyValue<ExecutorService> schedulerToHandleNonFinal) {
        WebSocketFramesHandler framesHandler = new WebSocketFramesHandler(schedulerToHandleNonFinal, firstFrame -> callback.onMessage((WebSocket)this, firstFrame.getContent()));
        return frame -> {
            try {
                framesHandler.onFrame((WebSocketFrame)frame);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private static String getCloseReason(WebSocketCloseStatus closeStatus) {
        if (closeStatus == null) {
            return "Unknown";
        }
        return closeStatus.reasonText();
    }

    private static WebSocketCloseCode getCloseCode(WebSocketCloseStatus closeStatus) {
        if (closeStatus == null) {
            return WebSocketCloseCode.PROTOCOL_ERROR;
        }
        try {
            return WebSocketCloseCode.fromProtocolCode((int)closeStatus.code());
        }
        catch (IllegalArgumentException iea) {
            return WebSocketCloseCode.PROTOCOL_ERROR;
        }
    }

    public String getId() {
        return this.socketId;
    }

    public WebSocket.WebSocketType getType() {
        return WebSocket.WebSocketType.OUTBOUND;
    }

    public WebSocketProtocol getProtocol() {
        return this.protocol;
    }

    public URI getUri() {
        return this.uri;
    }

    public boolean supportsReconnection() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<WebSocket> reconnect(RetryPolicyTemplate retryPolicyTemplate, Scheduler scheduler) {
        CompletableFuture<Object> f;
        this.reconnectionLock.lock();
        try {
            f = this.ongoingReconnection.get();
            if (f != null) {
                CompletableFuture<WebSocket> completableFuture = f;
                return completableFuture;
            }
            f = new CompletableFuture();
            this.ongoingReconnection.set(f);
        }
        finally {
            this.reconnectionLock.unlock();
        }
        CompletableFuture<Object> effectiveFuture = f;
        this.reconnectionHandler.reconnect(this, retryPolicyTemplate, scheduler).whenComplete((v, e) -> {
            this.reconnectionLock.lock();
            try {
                if (e != null) {
                    effectiveFuture.completeExceptionally((Throwable)e);
                } else {
                    effectiveFuture.complete(v);
                }
            }
            finally {
                this.ongoingReconnection.set(null);
                this.reconnectionLock.unlock();
            }
        });
        return effectiveFuture;
    }

    public CompletableFuture<Void> send(InputStream content, MediaType mediaType) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (this.closed.get()) {
            future.completeExceptionally((Throwable)new WebSocketClosedException((WebSocket)this));
            return future;
        }
        if (!this.connected.get()) {
            future.completeExceptionally((Throwable)new WebSocketConnectionException((WebSocket)this));
            return future;
        }
        try {
            boolean isText = MediaTypeUtils.isStringRepresentable((MediaType)mediaType);
            this.outbound.sendObject((Publisher)new FramedPublisher(content, isText)).subscribe(new CompletingFutureSubscriber(future));
        }
        catch (Exception t) {
            future.completeExceptionally(WebSocketUtils.mapWsException(t, this));
        }
        return future;
    }

    public CompletableFuture<Void> close(WebSocketCloseCode code, String reason) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.outbound.sendClose(code.getProtocolCode(), reason).doOnSuccess(s -> {
            this.closed.set(true);
            this.connected.set(false);
            future.complete(null);
        }).doOnError(future::completeExceptionally).subscribe();
        return future;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isConnected() {
        return this.connected.get();
    }

    @Override
    protected CompletableFuture<Void> sendFrame(WebSocketFrame frame) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.outbound.sendObject((Object)frame).subscribe(new CompletingFutureSubscriber(future));
        return future;
    }

    private static final class CompletingFutureSubscriber<T>
    implements Subscriber<T> {
        private final CompletableFuture<Void> future;

        CompletingFutureSubscriber(CompletableFuture<Void> future) {
            this.future = future;
        }

        public void onSubscribe(Subscription s) {
        }

        public void onNext(T t) {
        }

        public void onError(Throwable t) {
            this.future.completeExceptionally(t);
        }

        public void onComplete() {
            this.future.complete(null);
        }
    }
}

