/*
 * (c) 2003-2018 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.service.http.impl.provider;

import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.service.ServiceDefinition;
import org.mule.runtime.api.service.ServiceProvider;
import org.mule.runtime.http.api.HttpService;

import com.mulesoft.service.http.impl.service.EEHttpServiceImplementation;

import javax.inject.Inject;

public class EEHttpServiceProvider implements ServiceProvider {

  @Inject
  private SchedulerService schedulerService;

  @Override
  public ServiceDefinition getServiceDefinition() {
    EEHttpServiceImplementation service = new EEHttpServiceImplementation(schedulerService);
    ServiceDefinition serviceDefinition = new ServiceDefinition(HttpService.class, service);

    return serviceDefinition;
  }

}
